/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.util;

import com.cursedcauldron.unvotedandshelved.client.entity.models.ModelModifier;
import com.cursedcauldron.unvotedandshelved.util.Keyframe;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record Transformation(Target target, Keyframe[] keyframes) {
    public static float catmullrom(float delta, float p0, float p1, float p2, float p3) {
        return 0.5f * (2.0f * p1 + (p2 - p0) * delta + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * delta * delta + (3.0f * p1 - p0 - 3.0f * p2 + p3) * delta * delta * delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Target {
        public void apply(ModelPart var1, Vector3f var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Interpolation {
        public void apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Targets {
        public static final Target TRANSLATE = ModelModifier::translate;
        public static final Target ROTATE = ModelModifier::rotate;
        public static final Target SCALE = ModelModifier::scale;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Interpolations {
        public static final Interpolation LINEAL = (animationProgress, delta, keyframes, start, end, speed) -> {
            Vector3f startTarget = keyframes[start].target();
            Vector3f endTarget = keyframes[end].target();
            animationProgress.m_122245_(Mth.m_14179_((float)delta, (float)startTarget.m_122239_(), (float)endTarget.m_122239_()) * speed, Mth.m_14179_((float)delta, (float)startTarget.m_122260_(), (float)endTarget.m_122260_()) * speed, Mth.m_14179_((float)delta, (float)startTarget.m_122269_(), (float)endTarget.m_122269_()) * speed);
        };
        public static final Interpolation CATMULLROM = (animationProgress, delta, keyframes, start, end, speed) -> {
            Vector3f firstTarget = keyframes[Math.max(0, start - 1)].target();
            Vector3f secondTarget = keyframes[start].target();
            Vector3f thirdTarget = keyframes[end].target();
            Vector3f fourthTarget = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            animationProgress.m_122245_(Transformation.catmullrom(delta, firstTarget.m_122239_(), secondTarget.m_122239_(), thirdTarget.m_122239_(), fourthTarget.m_122239_()) * speed, Transformation.catmullrom(delta, firstTarget.m_122260_(), secondTarget.m_122260_(), thirdTarget.m_122260_(), fourthTarget.m_122260_()) * speed, Transformation.catmullrom(delta, firstTarget.m_122269_(), secondTarget.m_122269_(), thirdTarget.m_122269_(), fourthTarget.m_122269_()) * speed);
        };
    }
}

