/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.MineTweakerAPI;
import net.darkhax.badmobs.addons.crt.BadMobsTweaker;
import net.darkhax.badmobs.handler.ConfigurationHandler;
import net.darkhax.badmobs.handler.EntitySpawningHandler;
import net.darkhax.badmobs.item.ItemDataChecker;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="badmobs", name="Bad Mobs", version="1.0.20", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.11.2]")
public class BadMobs {
    public static final List<String> GLOBAL_BLACKLIST = new ArrayList<String>();
    public static final Map<Integer, List<String>> DIMENSIONAL_BLACKLIST = new HashMap<Integer, List<String>>();
    public static Item infoBook = new ItemDataChecker();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent pre) {
        new ConfigurationHandler(pre.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawningHandler());
        if (!ConfigurationHandler.serverMode) {
            GameRegistry.register((IForgeRegistryEntry)infoBook);
            if (pre.getSide().equals((Object)Side.CLIENT)) {
                ModelLoader.setCustomModelResourceLocation((Item)infoBook, (int)0, (ModelResourceLocation)new ModelResourceLocation("badmobs:infobook", "inventory"));
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        if (Loader.isModLoaded((String)"crafttweaker")) {
            MineTweakerAPI.registerClass(BadMobsTweaker.class);
        }
    }

    public static void blacklist(String entity) {
        GLOBAL_BLACKLIST.add(entity);
    }

    public static void remove(String entity) {
        GLOBAL_BLACKLIST.remove(entity);
    }

    public static void blacklist(int id, String entity) {
        if (!DIMENSIONAL_BLACKLIST.containsKey(id)) {
            DIMENSIONAL_BLACKLIST.put(id, new ArrayList());
        }
        DIMENSIONAL_BLACKLIST.get(id).add(entity);
    }

    public static void remove(int id, String entity) {
        if (!DIMENSIONAL_BLACKLIST.containsKey(id)) {
            DIMENSIONAL_BLACKLIST.put(id, new ArrayList());
        }
        DIMENSIONAL_BLACKLIST.get(id).remove(entity);
    }

    public static boolean isBlacklisted(Entity entity) {
        String entityId = EntityList.func_75621_b((Entity)entity);
        return GLOBAL_BLACKLIST.contains(entityId) ? true : (DIMENSIONAL_BLACKLIST.get(entity.field_71093_bK) != null ? DIMENSIONAL_BLACKLIST.get(entity.field_71093_bK).contains(entityId) : false);
    }
}

