/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.addons.crt;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import net.darkhax.badmobs.BadMobs;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.BadMobs")
public class BadMobsTweaker {
    @ZenMethod
    public static void blacklist(int dimId, String entityId) {
        MineTweakerAPI.apply((IUndoableAction)new BlacklistDimensional(dimId, entityId));
    }

    @ZenMethod
    public static void blacklist(String entityId) {
        MineTweakerAPI.apply((IUndoableAction)new BlacklistGlobal(entityId));
    }

    public static class BlacklistDimensional
    implements IUndoableAction {
        private final int dimId;
        private final String entityId;

        public BlacklistDimensional(int dimId, String entityId) {
            this.dimId = dimId;
            this.entityId = entityId;
        }

        public void apply() {
            BadMobs.blacklist(this.dimId, this.entityId);
        }

        public String describe() {
            return "blacklisting " + this.entityId + " from dim " + this.dimId;
        }

        public void undo() {
            BadMobs.remove(this.dimId, this.entityId);
        }

        public String describeUndo() {
            return "removing " + this.entityId + " from dim " + this.dimId;
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    public static class BlacklistGlobal
    implements IUndoableAction {
        private final String entityId;

        public BlacklistGlobal(String entityId) {
            this.entityId = entityId;
        }

        public void apply() {
            BadMobs.blacklist(this.entityId);
        }

        public String describe() {
            return "blacklisting " + this.entityId + " globally";
        }

        public void undo() {
            BadMobs.remove(this.entityId);
        }

        public String describeUndo() {
            return "removing " + this.entityId + " globally";
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }
}

