/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.handler;

import java.io.File;
import net.darkhax.badmobs.BadMobs;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean serverMode;
    public static boolean killMode;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
        this.syncConfigData();
    }

    private void syncConfigData() {
        String[] entries;
        serverMode = config.getBoolean("serverMode", "general", serverMode, "If this is set to true, the mod will be put into server-side mode. This will remove the Entity Data Book from the game, but will allow clients to connect to your server, without having the mod installed.");
        killMode = config.getBoolean("killMode", "general", killMode, "If this is set to true, bad mobs will be killed/deleted when they attempt to spawn. If this is set to false, the mob will not be removed from the world and only the spawning will be prevented, and when the mob is nolonger listed as bad, all previously prevented mobs of that type will spawn.");
        for (String entry : entries = config.getStringList("bannedMobs", "general", new String[]{"example1", "example2", "example3"}, "A list of all banned mobs. If a mobs entity name is added to this list, it will not be allowed to spawn in any world. To get the name of an entity, interact with it using the data checker and it's name will be given.")) {
            String[] parts = entry.split("#");
            if (parts.length == 2 && NumberUtils.isNumber((String)parts[1])) {
                int dimId = Integer.parseInt(parts[1]);
                BadMobs.blacklist(dimId, parts[0]);
                continue;
            }
            BadMobs.blacklist(entry);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        serverMode = false;
        killMode = true;
    }
}

