/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import net.darkhax.badmobs.Blacklist;
import net.darkhax.badmobs.Configuration;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="badmobs")
public class BadMobs {
    public static final Logger log = LogManager.getLogger((String)"Bad Mobs");
    private final Configuration config = new Configuration();
    private final Blacklist blacklist = new Blacklist();

    public BadMobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.config.getSpec());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLodaded);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        for (String string : this.config.getBannedMobs()) {
            ResourceLocation id = new ResourceLocation(string);
            if (ForgeRegistries.ENTITIES.containsKey(id)) {
                this.blacklist.blacklistGlobal(id);
                continue;
            }
            log.error("Tried to blacklist mob {} but no mob exists with that ID!", (Object)id.toString());
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            for (EnumCreatureType type : EnumCreatureType.values()) {
                biome.func_76747_a(type).removeIf(entry -> this.blacklist.isBlacklisted(entry.field_200702_b));
            }
        }
    }

    private void onConfigLodaded(ModConfig.Loading loaded) {
        if ("badmobs".equalsIgnoreCase(loaded.getConfig().getModId())) {
            log.info("Loading blacklist from config file.");
            this.blacklist.clear();
            for (String string : this.config.getBannedMobs()) {
                this.blacklist.blacklistGlobal(string);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onItemTooltip(ItemTooltipEvent event) {
        ItemSpawnEgg egg;
        EntityType type;
        if (this.config.addTooltip() && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof ItemSpawnEgg && (type = (egg = (ItemSpawnEgg)event.getItemStack().func_77973_b()).func_208076_b(event.getItemStack().func_77978_p())) != null) {
            event.getToolTip().add(new TextComponentTranslation("tip.badmobs.entityid", new Object[]{type.getRegistryName().toString()}));
        }
    }
}

