/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import net.darkhax.badmobs.Blacklist;
import net.darkhax.badmobs.Configuration;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="badmobs")
public class BadMobs {
    public static final Logger log = LogManager.getLogger((String)"Bad Mobs");
    private final Configuration config = new Configuration();
    private final Blacklist blacklist = new Blacklist();

    public BadMobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.config.getSpec());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLodaded);
        MinecraftForge.EVENT_BUS.addListener(this::checkSpawn);
        MinecraftForge.EVENT_BUS.addListener(this::specialSpawn);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            for (EntityClassification type : EntityClassification.values()) {
                biome.func_76747_a(type).removeIf(entry -> this.blacklist.isBlacklisted(entry.field_200702_b));
            }
        }
    }

    private void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (this.blacklist.isBlacklisted(event.getEntity(), event.getSpawnReason())) {
            event.getEntity().func_70106_y();
            event.setResult(Event.Result.DENY);
        }
    }

    private void specialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (this.blacklist.isBlacklisted(event.getEntity(), event.getSpawnReason())) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    private void onConfigLodaded(ModConfig.Loading loaded) {
        if ("badmobs".equalsIgnoreCase(loaded.getConfig().getModId())) {
            this.blacklist.load(this.config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onItemTooltip(ItemTooltipEvent event) {
        SpawnEggItem egg;
        EntityType type;
        if (event.getFlags().func_194127_a() && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof SpawnEggItem && (type = (egg = (SpawnEggItem)event.getItemStack().func_77973_b()).func_208076_b(event.getItemStack().func_77978_p())) != null) {
            event.getToolTip().add(new TranslationTextComponent("tip.badmobs.entityid", new Object[]{type.getRegistryName().toString()}));
        }
    }
}

