/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Queues;
import com.hamusuke.damageindicator.client.gui.screen.ConfigScreen;
import com.hamusuke.damageindicator.client.renderer.IndicatorRenderer;
import com.hamusuke.damageindicator.config.ClientConfig;
import com.hamusuke.damageindicator.network.DamageIndicatorPacket;
import com.hamusuke.damageindicator.network.NetworkManager;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Queue;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class DamageIndicatorClient
implements ClientModInitializer {
    public static final Queue<IndicatorRenderer> queue = Queues.newLinkedBlockingDeque();
    public static final ClientConfig clientConfig = new ClientConfig(FabricLoader.getInstance().getConfigDir().resolve("damageindicator/config.json").toFile());
    private static final class_304 HIDE_INDICATOR = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.damageindicator.hideIndicator.desc", 66, "key.damageindicator.category.indicator"));

    public void onInitializeClient() {
        clientConfig.load();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (client.field_1724 != null) {
                client.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Type '/damageindicatorconfig' to open config screen of Damage Indicator Mod."));
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"damageindicatorconfig").executes(context -> {
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_18858(() -> client.method_1507((class_437)new ConfigScreen(null)));
            return 1;
        })));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkManager.DAMAGE_PACKET_ID, (client, handler, buf, responseSender) -> {
            DamageIndicatorPacket packet;
            class_1297 entity;
            if (client.field_1687 != null && client.field_1724 != null && (entity = client.field_1687.method_8469((packet = new DamageIndicatorPacket(buf)).getEntityId())) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                double x = livingEntity.method_23322(0.5);
                double y = livingEntity.method_23323(class_3532.method_15366((class_5819)livingEntity.method_6051(), (double)0.5, (double)1.2));
                double z = livingEntity.method_23325(0.5);
                class_243 vec3d = new class_243(x, y, z);
                float distance = (float)client.field_1773.method_19418().method_19326().method_1022(vec3d);
                class_3965 result = client.field_1687.method_17742(new class_3959(client.field_1724.method_19538(), vec3d, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)client.field_1724));
                if ((((Boolean)DamageIndicatorClient.clientConfig.forciblyRenderIndicator.get()).booleanValue() || result.method_17783() == class_239.class_240.field_1333) && distance <= (float)DamageIndicatorClient.clientConfig.renderDistance.get().intValue()) {
                    queue.add(new IndicatorRenderer(x, y, z, packet.getText(), packet.getSource(), packet.isCrit(), distance));
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!client.method_1493()) {
                queue.forEach(IndicatorRenderer::tick);
                queue.removeIf(IndicatorRenderer::isDead);
            }
            while (HIDE_INDICATOR.method_1436()) {
                DamageIndicatorClient.clientConfig.hideIndicator.toggle();
                clientConfig.save();
            }
        });
    }
}

