/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client.renderer;

import com.hamusuke.damageindicator.client.DamageIndicatorClient;
import com.hamusuke.damageindicator.math.AdditionalMathHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class IndicatorRenderer {
    protected static final int maxAge = 20;
    protected static final float NORMAL = 1.0f;
    protected static final float CRITICAL = 2.5f;
    private static final class_310 mc = class_310.method_1551();
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;
    protected double x;
    protected double y;
    protected double z;
    protected final String source;
    protected boolean dead;
    protected int age;
    protected final class_2561 text;
    protected final boolean crit;
    protected float velocity;
    protected int color;
    protected int textWidth = -1;
    protected long startedTickingTimeMs;
    protected final float distance;
    protected final float scaleMultiplier;
    protected float currentScale = Float.NaN;
    protected boolean paused;
    protected long passedTimeMs;

    public IndicatorRenderer(double x, double y, double z, class_2561 text, String source, boolean crit, float distance) {
        this.setPos(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.text = text;
        this.source = source;
        this.crit = crit;
        this.syncIndicatorColor();
        this.distance = distance;
        this.scaleMultiplier = this.crit ? 2.5f : 1.0f;
        this.startedTickingTimeMs = class_156.method_658();
    }

    public void tick() {
        this.prevPosX = this.x;
        this.prevPosY = this.y;
        this.prevPosZ = this.z;
        if (this.age++ >= 20) {
            this.markDead();
        } else if (this.age > 10) {
            this.velocity += 0.008f;
            this.velocity *= 0.98f;
            this.moveOnHypotenuse3d(this.velocity);
        } else {
            if (this.currentScale != this.currentScale) {
                this.calculateScale(mc.method_1493());
            }
            this.moveOnHypotenuse3d(this.currentScale * 0.5f);
        }
    }

    private void moveOnHypotenuse3d(float lengthOfHypotenuseToMove) {
        if (IndicatorRenderer.mc.field_1687 == null) {
            this.markDead();
        } else {
            float phi = -IndicatorRenderer.mc.method_1561().field_4686.method_19330() * ((float)Math.PI / 180);
            float theta = IndicatorRenderer.mc.method_1561().field_4686.method_19329() * ((float)Math.PI / 180);
            float hypotenuse2d = lengthOfHypotenuseToMove * class_3532.method_15374((float)theta);
            this.setPos(this.x + (double)(hypotenuse2d * class_3532.method_15374((float)phi)), this.y + (double)(lengthOfHypotenuseToMove * class_3532.method_15362((float)theta)), this.z + (double)(hypotenuse2d * class_3532.method_15362((float)phi)));
        }
    }

    public void render(class_4587 matrix, class_4597 vertexConsumers, class_4184 camera, float tickDelta) {
        class_327 textRenderer = IndicatorRenderer.mc.field_1772;
        if (this.textWidth < 0) {
            this.textWidth = textRenderer.method_27525((class_5348)this.text);
        }
        if (this.textWidth == 0) {
            this.markDead();
        } else {
            float scale = this.calculateScale(mc.method_1493());
            double x = class_3532.method_16436((double)tickDelta, (double)this.prevPosX, (double)this.x);
            double y = class_3532.method_16436((double)tickDelta, (double)this.prevPosY, (double)this.y);
            double z = class_3532.method_16436((double)tickDelta, (double)this.prevPosZ, (double)this.z);
            class_243 camPos = camera.method_19326();
            double camX = camPos.field_1352;
            double camY = camPos.field_1351;
            double camZ = camPos.field_1350;
            matrix.method_22903();
            matrix.method_22904(x - camX, y - camY, z - camZ);
            matrix.method_22907(class_1160.field_20705.method_23214(-camera.method_19330()));
            matrix.method_22907(class_1160.field_20703.method_23214(camera.method_19329()));
            matrix.method_22905(-scale, -scale, scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            int alpha = 255;
            if (this.age > 10) {
                alpha = (int)((21.0f / (float)this.age - 1.0f) * 255.0f);
            }
            alpha = class_3532.method_15340((int)alpha, (int)0, (int)255);
            int color = this.color;
            if (this.age <= 3) {
                color = AdditionalMathHelper.lerpColor((float)(class_156.method_658() - this.startedTickingTimeMs) / 150.0f, color);
            }
            float f = (float)(-textRenderer.method_27525((class_5348)this.text)) / 2.0f;
            Objects.requireNonNull(textRenderer);
            textRenderer.method_30882(this.text, f, (float)(-9) / 2.0f, color + (alpha << 24), false, matrix.method_23760().method_23761(), vertexConsumers, true, 0, 0xF000F0);
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            matrix.method_22909();
        }
    }

    protected float calculateScale(boolean isPaused) {
        long timeDelta = class_156.method_658() - this.startedTickingTimeMs;
        float scale = AdditionalMathHelper.convexUpwardQuadraticFunction(class_3532.method_15363((float)((float)timeDelta / 250.0f), (float)0.0f, (float)1.0f), this.crit ? -0.2f : -0.5f, this.crit ? 2.0f : 0.5f, 0.00375f * this.distance * 1.7320508f * this.scaleMultiplier, 0.0075f * this.distance * 1.7320508f * this.scaleMultiplier * this.scaleMultiplier * (this.crit ? 1.0f : 0.8f));
        scale -= 2.5E-4f * (float)this.textWidth;
        scale = class_3532.method_15363((float)scale, (float)1.0E-4f, (float)Float.MAX_VALUE);
        if (isPaused && !this.paused) {
            this.passedTimeMs = timeDelta;
            this.paused = true;
        } else {
            if (isPaused) {
                return this.currentScale;
            }
            if (this.paused) {
                this.startedTickingTimeMs = class_156.method_658() - this.passedTimeMs;
                this.paused = false;
                return this.calculateScale(false);
            }
        }
        this.currentScale = scale;
        return this.currentScale;
    }

    public void markDead() {
        this.dead = true;
    }

    public void syncIndicatorColor() {
        this.color = DamageIndicatorClient.clientConfig.getRGBFromDamageSource((Boolean)DamageIndicatorClient.clientConfig.changeColorWhenCrit.get() != false && this.crit ? "critical" : this.source);
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isDead() {
        return this.dead;
    }
}

