/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.config.values;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hamusuke.damageindicator.config.values.AbstractConfig;
import com.hamusuke.damageindicator.config.values.IntValue;
import java.io.IOException;
import net.minecraft.class_3532;

public class RGBValue
extends AbstractConfig<RGB> {
    public RGBValue(String name, int red, int green, int blue) {
        super(name);
        this.value = new RGB(red, green, blue);
    }

    @Override
    public void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name(this.name).beginObject();
        ((RGB)this.value).write(jsonWriter);
        jsonWriter.endObject();
    }

    @Override
    public void read(JsonObject jsonObject) {
        if (jsonObject.has(this.name) && jsonObject.get(this.name).isJsonObject()) {
            JsonObject rgb = jsonObject.getAsJsonObject(this.name);
            ((RGB)this.value).read(rgb);
        }
    }

    public static class RGB {
        private final IntValue red;
        private final IntValue green;
        private final IntValue blue;

        public RGB(int red, int green, int blue) {
            this.red = new IntValue("red", red, 0, 255);
            this.green = new IntValue("green", green, 0, 255);
            this.blue = new IntValue("blue", blue, 0, 255);
        }

        public void write(JsonWriter writer) throws IOException {
            writer.name(this.red.name).value((long)this.getRed()).name(this.green.name).value((long)this.getGreen()).name(this.blue.name).value((long)this.getBlue());
        }

        public void read(JsonObject jsonObject) {
            if (jsonObject.has(this.red.name)) {
                this.setRed(jsonObject.get(this.red.name).getAsInt());
            }
            if (jsonObject.has(this.green.name)) {
                this.setGreen(jsonObject.get(this.green.name).getAsInt());
            }
            if (jsonObject.has(this.blue.name)) {
                this.setBlue(jsonObject.get(this.blue.name).getAsInt());
            }
        }

        public int getRed() {
            return this.red.get();
        }

        public void setRed(int red) {
            this.red.set(red);
        }

        public int getGreen() {
            return this.green.get();
        }

        public void setGreen(int green) {
            this.green.set(green);
        }

        public int getBlue() {
            return this.blue.get();
        }

        public void setBlue(int blue) {
            this.blue.set(blue);
        }

        public int toRGB() {
            return class_3532.method_15383((int)this.getRed(), (int)this.getGreen(), (int)this.getBlue());
        }
    }
}

