/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.hamusuke.damageindicator.client.gui.screen.ConfigScreen;
import com.hamusuke.damageindicator.client.renderer.IndicatorRenderer;
import com.hamusuke.damageindicator.config.ClientConfig;
import com.hamusuke.damageindicator.network.DamageIndicatorPacket;
import com.hamusuke.damageindicator.network.NetworkManager;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class DamageIndicatorClient
implements ClientModInitializer {
    public static final Queue<IndicatorRenderer> queue = Queues.newLinkedBlockingDeque();
    public static final ClientConfig clientConfig = new ClientConfig(FabricLoader.getInstance().getConfigDir().resolve("damageindicator/config.json").toFile());
    private static final class_304 OPEN_CONFIG = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.damageindicator.openConfig", 86, "key.damageindicator.category.indicator"));
    private static final class_304 HIDE_INDICATOR = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.damageindicator.hideIndicator.desc", 66, "key.damageindicator.category.indicator"));

    public void onInitializeClient() {
        clientConfig.load();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkManager.DAMAGE_PACKET_ID, (client, handler, buf, responseSender) -> {
            DamageIndicatorPacket packet;
            class_1297 entity;
            class_1297 livingEntity$temp;
            if (client.field_1687 != null && client.field_1724 != null && (livingEntity$temp = (entity = client.field_1687.method_8469((packet = new DamageIndicatorPacket(buf)).getEntityId()))) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)livingEntity$temp;
                double x = livingEntity.method_23322(0.5);
                double y = livingEntity.method_23323(class_3532.method_15366((Random)livingEntity.method_6051(), (double)0.5, (double)1.2));
                double z = livingEntity.method_23325(0.5);
                class_243 vec3d = new class_243(x, y, z);
                float distance = (float)client.field_1773.method_19418().method_19326().method_1022(vec3d);
                class_3965 result = client.field_1687.method_17742(new class_3959(client.field_1724.method_19538(), vec3d, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)client.field_1724));
                if ((((Boolean)DamageIndicatorClient.clientConfig.forciblyRenderIndicator.get()).booleanValue() || result.method_17783() == class_239.class_240.field_1333) && distance <= (float)DamageIndicatorClient.clientConfig.renderDistance.get().intValue()) {
                    queue.add(new IndicatorRenderer(x, y, z, packet.getText(), packet.getSource(), packet.isCrit(), distance));
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!client.method_1493()) {
                ArrayList list = Lists.newArrayList();
                queue.forEach(indicatorRenderer -> {
                    indicatorRenderer.tick();
                    if (!indicatorRenderer.isAlive()) {
                        list.add(indicatorRenderer);
                    }
                });
                queue.removeAll(list);
            }
            while (OPEN_CONFIG.method_1436()) {
                client.method_1507((class_437)new ConfigScreen(client.field_1755));
            }
            while (HIDE_INDICATOR.method_1436()) {
                DamageIndicatorClient.clientConfig.hideIndicator.toggle();
                clientConfig.save();
            }
        });
    }
}

