/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator;

import com.hamusuke.criticalib.invoker.EntityLivingBaseInvoker;
import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.NetworkManager;
import com.hamusuke.damageindicator.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="damageindicator", name="Damage Indicator", version="3.0.0", guiFactory="com.hamusuke.damageindicator.client.gui.screen.ConfigScreenFactory", updateJSON="https://raw.githubusercontent.com/hamusuke0323/DamageIndicatorForge/update/update.json", dependencies="required-after:criticalib@[1.0.2,);")
public class DamageIndicator {
    public static final String MOD_ID = "damageindicator";
    public static final String MOD_NAME = "Damage Indicator";
    public static final String VERSION = "3.0.0";
    public static final Logger LOGGER = LogManager.getLogger();
    @SidedProxy(clientSide="com.hamusuke.damageindicator.proxy.ClientProxy", serverSide="com.hamusuke.damageindicator.proxy.CommonProxy")
    public static CommonProxy PROXY;
    private static Configuration config;

    public static Configuration getConfig() {
        return config;
    }

    private static void syncConfig(boolean load) {
        if (load) {
            config.load();
        }
        PROXY.onConfigChanged(config);
    }

    @Mod.EventHandler
    private void onSetup(FMLPreInitializationEvent event) {
        NetworkManager.init();
        PROXY.preInit(event);
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        DamageIndicator.syncConfig(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeal(LivingHealEvent event) {
        EntityLivingBase livingEntity = event.getEntityLiving();
        if (!event.isCanceled() && livingEntity instanceof LivingEntityInvoker) {
            float amount = Math.min(livingEntity.func_110138_aP() - livingEntity.func_110143_aJ(), event.getAmount());
            if (!livingEntity.field_70170_p.field_72995_K && amount > 0.0f) {
                ((LivingEntityInvoker)livingEntity).send("+" + MathHelper.func_76123_f((float)amount), "heal", false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamageLast(LivingDamageEvent event) {
        EntityLivingBase livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K && livingEntity instanceof LivingEntityInvoker) {
            DamageSource source = event.getSource();
            boolean bl = false;
            Entity entity = source.func_76346_g();
            if (entity instanceof LivingEntityInvoker) {
                bl = ((EntityLivingBaseInvoker)entity).isCritical();
            }
            ((LivingEntityInvoker)livingEntity).send("" + MathHelper.func_76123_f((float)event.getAmount()), source.func_76355_l(), bl);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MOD_ID.equals(event.getModID())) {
            DamageIndicator.syncConfig(false);
        }
    }
}

