/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hamusuke.damageindicator.client.DamageIndicatorClient;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class CustomScriptManager
implements ISelectiveResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private final ScriptEngine js;
    private final LinkedHashMap<ResourceLocation, String> scripts = Maps.newLinkedHashMap();
    @Nullable
    private Invocable invocable;

    public CustomScriptManager() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.js = scriptEngineManager.getEngineByName("rhino");
        LOGGER.info("Got Rhino JavaScript Engine or not: {}", (Object)(this.js == null ? "null" : "got"));
        if (this.js != null) {
            this.js.put("maxAge", 20);
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.scripts.clear();
        DamageIndicatorClient.getInstance().clearQueue();
        String path = "script/custom_indicator_renderer.js";
        for (String domain : Lists.reverse((List)Lists.newArrayList((Iterable)resourceManager.func_135055_a()))) {
            ResourceLocation resourceLocation = new ResourceLocation(domain, path);
            try {
                IResource resource = resourceManager.func_110536_a(resourceLocation);
                this.registerScript(resourceLocation, IOUtils.readLines((InputStream)resource.func_110527_b(), (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception exception) {}
        }
        this.invocable = this.loadScript();
    }

    private void registerScript(ResourceLocation resourceLocation, List<String> script) {
        String str = StringUtils.join(script, (char)'\n');
        this.scripts.put(resourceLocation, str);
        LOGGER.info("Registered animation script:\n{}", (Object)str);
    }

    @Nullable
    private Invocable loadScript() {
        if (this.js != null) {
            for (String script : this.scripts.values()) {
                try {
                    this.js.eval(script);
                    return (Invocable)((Object)this.js);
                }
                catch (Exception e) {
                    LOGGER.warn("Error occurred while loading JavaScript. Try to load the next script if it exists", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Nullable
    public Invocable getInvocable() {
        return this.invocable;
    }

    public void errorOccurred() {
        this.invocable = null;
    }
}

