/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.hamusuke.damageindicator.client.CustomScriptManager;
import com.hamusuke.damageindicator.client.renderer.IndicatorRenderer;
import com.hamusuke.damageindicator.config.ClientConfig;
import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DamageIndicatorClient {
    public static final float NORMAL = 1.0f;
    public static final float CRITICAL = 2.5f;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Queue<IndicatorRenderer> queue = Queues.newLinkedBlockingDeque();
    private static DamageIndicatorClient instance;
    private final CustomScriptManager customScriptManager;

    public DamageIndicatorClient() {
        instance = this;
        this.customScriptManager = new CustomScriptManager();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this.customScriptManager);
    }

    @SubscribeEvent
    public void onEndTick(TickEvent.ClientTickEvent event) {
        if (!mc.func_147113_T() && event.phase == TickEvent.Phase.END) {
            ArrayList list = Lists.newArrayList();
            this.queue.forEach(indicatorRenderer -> {
                indicatorRenderer.tick();
                if (!indicatorRenderer.isAlive()) {
                    list.add(indicatorRenderer);
                }
            });
            this.queue.removeAll(list);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!DamageIndicatorClient.mc.field_71474_y.field_74319_N && !this.queue.isEmpty()) {
            DamageIndicatorClient.mc.field_71424_I.func_76320_a("damage indicator rendering");
            this.queue.forEach(indicatorRenderer -> indicatorRenderer.render(event.getPartialTicks()));
            DamageIndicatorClient.mc.field_71424_I.func_76319_b();
        }
    }

    public void addRenderer(int entityId, String text, String source, boolean crit) {
        Entity clientEntity = DamageIndicatorClient.mc.field_71441_e.func_73045_a(entityId);
        Entity renderViewEntity = mc.func_175606_aa();
        if (clientEntity instanceof LivingEntityInvoker && renderViewEntity != null) {
            LivingEntityInvoker invoker = (LivingEntityInvoker)clientEntity;
            double x = invoker.getRandomX(0.5);
            double y = invoker.getRandomY(MathHelper.func_82716_a((Random)invoker.getRandom(), (double)0.5, (double)1.2));
            double z = invoker.getRandomZ(0.5);
            float distance = (float)Math.sqrt(mc.func_175598_ae().func_78714_a(x, y, z));
            RayTraceResult result = DamageIndicatorClient.mc.field_71441_e.func_72933_a(new Vec3d(x, y, z), new Vec3d(DamageIndicatorClient.mc.func_175598_ae().field_78730_l, DamageIndicatorClient.mc.func_175598_ae().field_78731_m + (double)renderViewEntity.func_70047_e(), DamageIndicatorClient.mc.func_175598_ae().field_78728_n));
            if ((ClientConfig.forceIndicatorRendering || result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) && distance <= (float)ClientConfig.renderDistance) {
                this.queue.add(new IndicatorRenderer(x, y, z, text, source, distance, crit));
            }
        }
    }

    public void syncIndicatorColor() {
        this.queue.forEach(IndicatorRenderer::syncIndicatorColor);
    }

    public void clearQueue() {
        this.queue.clear();
    }

    public CustomScriptManager getCustomScriptManager() {
        return this.customScriptManager;
    }

    public static DamageIndicatorClient getInstance() {
        return instance;
    }
}

