/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client.renderer;

import com.hamusuke.damageindicator.client.CustomScriptManager;
import com.hamusuke.damageindicator.client.DamageIndicatorClient;
import com.hamusuke.damageindicator.config.ClientConfig;
import com.hamusuke.damageindicator.math.AdditionalMathHelper;
import javax.script.Invocable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class IndicatorRenderer {
    public static final int maxAge = 20;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final Minecraft mc = Minecraft.func_71410_x();
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;
    protected double x;
    protected double y;
    protected double z;
    public final String text;
    protected boolean dead;
    public final String damageSourceType;
    public final boolean crit;
    public final int textWidth;
    public final float distance;
    protected int color;
    public final float scaleMultiplier;
    protected long startedTickingTimeMs;
    public float velocity;
    public int age;
    public float currentScale;
    protected boolean paused;
    protected long passedTimeMs;

    public IndicatorRenderer(double x, double y, double z, String text, String damageSourceType, float distance, boolean crit) {
        this.setPos(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.text = text;
        this.textWidth = IndicatorRenderer.mc.field_71466_p.func_78256_a(this.text);
        this.damageSourceType = damageSourceType;
        this.crit = crit;
        this.syncIndicatorColor();
        this.distance = distance;
        this.scaleMultiplier = this.crit ? 2.5f : 1.0f;
        this.startedTickingTimeMs = System.currentTimeMillis();
    }

    private static CustomScriptManager getManager() {
        return DamageIndicatorClient.getInstance().getCustomScriptManager();
    }

    public void tick() {
        this.prevPosX = this.x;
        this.prevPosY = this.y;
        this.prevPosZ = this.z;
        Invocable invocable = IndicatorRenderer.getManager().getInvocable();
        if (invocable != null) {
            try {
                invocable.invokeFunction("tick", this);
                return;
            }
            catch (Exception e) {
                IndicatorRenderer.getManager().errorOccurred();
                LOGGER.warn("Error occurred while invoking method", (Throwable)e);
            }
        }
        this.tickDefault();
    }

    private void tickDefault() {
        if (this.age++ >= 20) {
            this.markDead();
        } else if (this.age > 10) {
            this.velocity += 0.008f;
            this.velocity *= 0.98f;
            this.moveOnHypotenuse3d(this.velocity);
        } else {
            this.moveOnHypotenuse3d(this.currentScale * 0.5f);
        }
    }

    public void moveOnHypotenuse3d(float lengthOfHypotenuseToMove) {
        float[] yawPitch = this.calculateAngle();
        float phi = yawPitch[0] * ((float)Math.PI / 180);
        float theta = yawPitch[1] * ((float)Math.PI / 180);
        float hypotenuse2d = lengthOfHypotenuseToMove * MathHelper.func_76126_a((float)theta);
        this.setPos(this.x + (double)(hypotenuse2d * MathHelper.func_76126_a((float)phi)), this.y + (double)(lengthOfHypotenuseToMove * MathHelper.func_76134_b((float)theta)), this.z + (double)(hypotenuse2d * MathHelper.func_76134_b((float)phi)));
    }

    private float[] calculateAngle() {
        float[] fArray;
        if (IndicatorRenderer.mc.field_71474_y.field_74320_O == 2) {
            float[] fArray2 = new float[2];
            fArray2[0] = -IndicatorRenderer.mc.func_175598_ae().field_78735_i;
            fArray = fArray2;
            fArray2[1] = -IndicatorRenderer.mc.func_175598_ae().field_78732_j;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -IndicatorRenderer.mc.func_175598_ae().field_78735_i;
            fArray = fArray3;
            fArray3[1] = IndicatorRenderer.mc.func_175598_ae().field_78732_j;
        }
        return fArray;
    }

    public void render(float tickDelta) {
        Entity renderViewEntity = IndicatorRenderer.mc.func_175598_ae().field_78734_h;
        if (renderViewEntity == null || this.textWidth <= 0) {
            this.markDead();
        } else {
            float scale = this.calculateScale(mc.func_147113_T());
            double x = AdditionalMathHelper.lerp((double)tickDelta, this.prevPosX, this.x);
            double y = AdditionalMathHelper.lerp((double)tickDelta, this.prevPosY, this.y);
            double z = AdditionalMathHelper.lerp((double)tickDelta, this.prevPosZ, this.z);
            double camX = IndicatorRenderer.mc.func_175598_ae().field_78730_l;
            double camY = IndicatorRenderer.mc.func_175598_ae().field_78731_m;
            double camZ = IndicatorRenderer.mc.func_175598_ae().field_78728_n;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x - camX), (double)(y - camY), (double)(z - camZ));
            float[] yawPitch = this.calculateAngle();
            GlStateManager.func_179114_b((float)yawPitch[0], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yawPitch[1], (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            GL11.glNormal3d((double)0.0, (double)0.0, (double)(-1.0 * (double)scale));
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int alpha = 255;
            if (this.age > 10) {
                alpha = (int)((21.0f / (float)this.age - 1.0f) * 255.0f);
            }
            alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
            int color = this.color;
            if (this.age <= 3) {
                color = AdditionalMathHelper.lerpColor((float)(System.currentTimeMillis() - this.startedTickingTimeMs) / 150.0f, color);
            }
            IndicatorRenderer.mc.field_71466_p.func_78276_b(this.text, -this.textWidth / 2, -IndicatorRenderer.mc.field_71466_p.field_78288_b / 2, color + (alpha << 24));
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    private float calculateScale(boolean isPaused) {
        float scale;
        long timeDelta = System.currentTimeMillis() - this.startedTickingTimeMs;
        Invocable invocable = IndicatorRenderer.getManager().getInvocable();
        if (invocable != null) {
            try {
                scale = (float)((Double)invocable.invokeFunction("calculateScale", timeDelta, this)).doubleValue();
            }
            catch (Exception e) {
                IndicatorRenderer.getManager().errorOccurred();
                LOGGER.warn("Error occurred while invoking method", (Throwable)e);
                scale = this.calculateScaleDefault(timeDelta);
            }
        } else {
            scale = this.calculateScaleDefault(timeDelta);
        }
        if (isPaused && !this.paused) {
            this.passedTimeMs = timeDelta;
            this.paused = true;
        } else {
            if (isPaused) {
                return this.currentScale;
            }
            if (this.paused) {
                this.startedTickingTimeMs = System.currentTimeMillis() - this.passedTimeMs;
                this.paused = false;
                return this.calculateScale(false);
            }
        }
        this.currentScale = scale;
        return this.currentScale;
    }

    private float calculateScaleDefault(long timeDelta) {
        float scale = AdditionalMathHelper.convexUpwardQuadraticFunction(MathHelper.func_76131_a((float)((float)timeDelta / 250.0f), (float)0.0f, (float)1.0f), this.crit ? -0.2f : -0.5f, this.crit ? 2.0f : 0.5f, 0.00375f * this.distance * 1.7320508f * this.scaleMultiplier, 0.0075f * this.distance * 1.7320508f * this.scaleMultiplier * this.scaleMultiplier * (this.crit ? 1.0f : 0.8f));
        scale -= 2.5E-4f * (float)this.textWidth;
        scale = MathHelper.func_76131_a((float)scale, (float)1.0E-4f, (float)20.0f);
        return scale;
    }

    public void syncIndicatorColor() {
        this.color = ClientConfig.ColorConfig.getColorFromDamageSourceType(ClientConfig.changeColorWhenCrit && this.crit ? "critical" : this.damageSourceType);
    }

    public void markDead() {
        this.dead = true;
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isAlive() {
        return !this.dead;
    }
}

