/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.mixin;

import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.DamageIndicatorPacket;
import com.hamusuke.damageindicator.network.NetworkManager;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLivingBase.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityInvoker {
    @Shadow
    public int field_70771_an;
    protected int showImmuneCoolTime;
    @Shadow
    protected float field_110153_bc;

    @Shadow
    public abstract float func_110143_aJ();

    LivingEntityMixin(World worldIn) {
        super(worldIn);
    }

    @Inject(method={"onEntityUpdate"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.showImmuneCoolTime > 0) {
            --this.showImmuneCoolTime;
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="RETURN")})
    private void damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!(this instanceof EntityPlayer || this instanceof EntityShulker || this instanceof EntityWither || this.field_70170_p.field_72995_K || cir.getReturnValueZ() || !this.canSendImmune(amount))) {
            this.sendImmune();
        }
    }

    @Override
    public void send(String text, String source, boolean crit) {
        if (!this.field_70170_p.field_72995_K) {
            DamageIndicatorPacket damageIndicatorPacket = new DamageIndicatorPacket(this.func_145782_y(), text, source, crit);
            this.field_70170_p.func_73046_m().func_184103_al().func_181057_v().forEach(entityPlayer -> NetworkManager.sendToClient(damageIndicatorPacket, entityPlayer));
        }
    }

    @Override
    public Random getRandom() {
        return this.field_70146_Z;
    }

    @Override
    public double getRandomX(double scale) {
        return this.func_174791_d().field_72450_a + (double)this.field_70130_N * (2.0 * this.field_70146_Z.nextDouble() - 1.0) * scale;
    }

    @Override
    public double getRandomY(double scale) {
        return this.func_174791_d().field_72448_b + (double)this.field_70131_O * scale;
    }

    @Override
    public double getRandomZ(double scale) {
        return this.func_174791_d().field_72449_c + (double)this.field_70130_N * (2.0 * this.field_70146_Z.nextDouble() - 1.0) * scale;
    }

    @Override
    public void sendImmune() {
        this.showImmuneCoolTime = 10;
        this.send("damageindicator.indicator.immune", "immune", false);
    }

    @Override
    public boolean canSendImmune(float amount) {
        return !(!(this.func_110143_aJ() > 0.0f) || this.showImmuneCoolTime > 0 || (float)this.field_70172_ad > (float)this.field_70771_an / 2.0f && amount <= this.field_110153_bc);
    }
}

