/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator;

import com.hamusuke.damageindicator.client.DamageIndicatorClient;
import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.client.gui.screen.ConfigScreen;
import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="damageindicator")
public class DamageIndicator {
    public static final String MOD_ID = "damageindicator";

    public DamageIndicator() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CONFIG);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> ConfigScreen::new);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new DamageIndicatorClient()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onSetup(FMLCommonSetupEvent event) {
        NetworkManager.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!event.isCanceled() && livingEntity instanceof LivingEntityInvoker) {
            float amount = Math.min(livingEntity.func_110138_aP() - livingEntity.func_110143_aJ(), event.getAmount());
            if (!livingEntity.field_70170_p.field_72995_K && amount > 0.0f) {
                ((LivingEntityInvoker)livingEntity).send((ITextComponent)new StringTextComponent("+" + MathHelper.func_76123_f((float)amount)), "heal", false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamageLast(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K && livingEntity instanceof LivingEntityInvoker) {
            DamageSource source = event.getSource();
            boolean bl = false;
            Entity entity = source.func_76346_g();
            if (entity instanceof com.hamusuke.criticalib.invoker.LivingEntityInvoker) {
                bl = ((com.hamusuke.criticalib.invoker.LivingEntityInvoker)entity).isCritical();
            }
            ((LivingEntityInvoker)livingEntity).send((ITextComponent)new StringTextComponent("" + MathHelper.func_76123_f((float)event.getAmount())), source.func_76355_l(), bl);
        }
    }
}

