/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.client.renderer.IndicatorRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class DamageIndicatorClient {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Queue<IndicatorRenderer> queue = Queues.newLinkedBlockingDeque();
    private static DamageIndicatorClient instance;
    private static final KeyBinding hideIndicator;

    public DamageIndicatorClient() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
    }

    private void setup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)hideIndicator);
    }

    private void onConfigReload(ModConfig.Reloading event) {
        if (event.getConfig().getModId().equals("damageindicator")) {
            this.queue.forEach(IndicatorRenderer::syncIndicatorColor);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (hideIndicator.func_151468_f()) {
            Config.CLIENT.hideIndicator.set((Object)((Boolean)Config.CLIENT.hideIndicator.get() == false ? 1 : 0));
        }
    }

    @SubscribeEvent
    public void onEndTick(TickEvent.ClientTickEvent event) {
        if (!mc.func_147113_T() && event.phase == TickEvent.Phase.END) {
            ArrayList list = Lists.newArrayList();
            this.queue.forEach(indicatorRenderer -> {
                indicatorRenderer.tick();
                if (!indicatorRenderer.isAlive()) {
                    list.add(indicatorRenderer);
                }
            });
            this.queue.removeAll(list);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!((Boolean)Config.CLIENT.hideIndicator.get()).booleanValue() && !this.queue.isEmpty()) {
            mc.func_213239_aq().func_76320_a("damage indicator rendering");
            IRenderTypeBuffer.Impl impl = mc.func_228019_au_().func_228487_b_();
            MatrixStack matrices = event.getMatrixStack();
            matrices.func_227867_d_();
            matrices.func_227860_a_();
            this.queue.forEach(indicatorRenderer -> indicatorRenderer.render(matrices, (IRenderTypeBuffer)impl, DamageIndicatorClient.mc.func_175598_ae().field_217783_c, event.getPartialTicks()));
            matrices.func_227865_b_();
            impl.func_228461_a_();
            mc.func_213239_aq().func_76319_b();
        }
    }

    public void addRenderer(int entityId, ITextComponent text, String source, boolean crit) {
        Entity clientEntity;
        if (DamageIndicatorClient.mc.field_71441_e != null && DamageIndicatorClient.mc.field_71439_g != null && (clientEntity = DamageIndicatorClient.mc.field_71441_e.func_73045_a(entityId)) instanceof LivingEntity) {
            double x = clientEntity.func_226282_d_(0.5);
            double y = clientEntity.func_226283_e_(MathHelper.func_82716_a((Random)((LivingEntity)clientEntity).func_70681_au(), (double)0.5, (double)1.2));
            double z = clientEntity.func_226287_g_(0.5);
            Vector3d vector3d = new Vector3d(x, y, z);
            float distance = (float)DamageIndicatorClient.mc.field_71460_t.func_215316_n().func_216785_c().func_72438_d(vector3d);
            BlockRayTraceResult result = DamageIndicatorClient.mc.field_71441_e.func_217299_a(new RayTraceContext(DamageIndicatorClient.mc.field_71439_g.func_213303_ch(), vector3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
            if ((((Boolean)Config.CLIENT.forceIndicatorRendering.get()).booleanValue() || result.func_216346_c() == RayTraceResult.Type.MISS) && distance <= (float)((Integer)Config.CLIENT.renderDistance.get()).intValue()) {
                this.queue.add(new IndicatorRenderer(x, y, z, text, source, crit, distance));
            }
        }
    }

    public static DamageIndicatorClient getInstance() {
        return instance;
    }

    static {
        hideIndicator = new KeyBinding("key.damageindicator.hideIndicator.desc", -1, "key.damageindicator.category.indicator");
    }
}

