/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client.gui.screen;

import com.hamusuke.damageindicator.client.config.Config;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.apache.commons.lang3.mutable.MutableBoolean;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class ConfigScreen
extends Screen {
    private static final ITextComponent HIDE_INDICATOR = new TranslationTextComponent("options.damageindicator.hideIndicator");
    private static final ITextComponent FORCE_INDICATOR_RENDERING = new TranslationTextComponent("options.damageindicator.forceindicatorrendering");
    private static final ITextComponent CHANGE_COLOR_WHEN_CRIT = new TranslationTextComponent("options.damageindicator.changeColorWhenCrit");
    private final Screen parent;

    public ConfigScreen(Minecraft ignored, Screen parent) {
        super((ITextComponent)new TranslationTextComponent("options.title"));
        this.parent = parent;
    }

    private static ITextComponent percent(String key, String value) {
        return new TranslationTextComponent("options.percent_value", new Object[]{key, value});
    }

    protected void func_231160_c_() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 60, this.field_230708_k_ / 2, 20, (ITextComponent)DialogTexts.func_244281_a((ITextComponent)HIDE_INDICATOR, (boolean)((Boolean)Config.CLIENT.hideIndicator.get())), p_onPress_1_ -> {
            Config.CLIENT.hideIndicator.set((Object)((Boolean)Config.CLIENT.hideIndicator.get() == false ? 1 : 0));
            p_onPress_1_.func_238482_a_((ITextComponent)DialogTexts.func_244281_a((ITextComponent)HIDE_INDICATOR, (boolean)((Boolean)Config.CLIENT.hideIndicator.get())));
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 40, this.field_230708_k_ / 2, 20, (ITextComponent)DialogTexts.func_244281_a((ITextComponent)FORCE_INDICATOR_RENDERING, (boolean)((Boolean)Config.CLIENT.forceIndicatorRendering.get())), p_onPress_1_ -> {
            Config.CLIENT.forceIndicatorRendering.set((Object)((Boolean)Config.CLIENT.forceIndicatorRendering.get() == false ? 1 : 0));
            p_onPress_1_.func_238482_a_((ITextComponent)DialogTexts.func_244281_a((ITextComponent)FORCE_INDICATOR_RENDERING, (boolean)((Boolean)Config.CLIENT.forceIndicatorRendering.get())));
        }));
        this.func_230480_a_((Widget)new AbstractSlider(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 20, this.field_230708_k_ / 2, 20, (ITextComponent)new TranslationTextComponent("options.damageindicator.displayDistance").func_240702_b_(": ").func_240702_b_("" + Config.CLIENT.renderDistance.get()), (double)((Integer)Config.CLIENT.renderDistance.get()).intValue() / 1024.0){

            protected void func_230979_b_() {
                this.func_238482_a_((ITextComponent)new TranslationTextComponent("options.damageindicator.displayDistance").func_240702_b_(": ").func_240702_b_("" + Config.CLIENT.renderDistance.get()));
            }

            protected void func_230972_a_() {
                Config.CLIENT.renderDistance.set((Object)MathHelper.func_76125_a((int)((int)(this.field_230683_b_ * 1024.0)), (int)0, (int)1024));
            }
        });
        this.func_230480_a_((Widget)new AbstractSlider(this.field_230708_k_ / 4, this.field_230709_l_ / 2, this.field_230708_k_ / 2, 20, ConfigScreen.percent("options.damageindicator.fontSize", String.format("%.1f", (Double)Config.CLIENT.fontSize.get() * 100.0)), (Double)Config.CLIENT.fontSize.get()){

            protected void func_230979_b_() {
                this.func_238482_a_(ConfigScreen.percent("options.damageindicator.fontSize", String.format("%.1f", (Double)Config.CLIENT.fontSize.get() * 100.0)));
            }

            protected void func_230972_a_() {
                Config.CLIENT.fontSize.set((Object)MathHelper.func_151237_a((double)this.field_230683_b_, (double)0.0, (double)1.0));
            }
        });
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 4, this.field_230709_l_ / 2 + 20, this.field_230708_k_ / 2, 20, (ITextComponent)DialogTexts.func_244281_a((ITextComponent)CHANGE_COLOR_WHEN_CRIT, (boolean)((Boolean)Config.CLIENT.changeColorWhenCrit.get())), p_onPress_1_ -> {
            Config.CLIENT.changeColorWhenCrit.set((Object)((Boolean)Config.CLIENT.changeColorWhenCrit.get() == false ? 1 : 0));
            p_onPress_1_.func_238482_a_((ITextComponent)DialogTexts.func_244281_a((ITextComponent)CHANGE_COLOR_WHEN_CRIT, (boolean)((Boolean)Config.CLIENT.changeColorWhenCrit.get())));
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 4, this.field_230709_l_ / 2 + 40, this.field_230708_k_ / 2, 20, (ITextComponent)new TranslationTextComponent("damageindicator.config.colorConfig.title"), p_onPress_1_ -> this.field_230706_i_.func_147108_a((Screen)new ColorSettingsScreen(this))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 4, this.field_230709_l_ - 20, this.field_230708_k_ / 2, 20, DialogTexts.field_240632_c_, p_onPress_1_ -> this.func_231175_as__()));
    }

    public void func_230430_a_(MatrixStack p_96562_, int p_96563_, int p_96564_, float p_96565_) {
        this.func_230446_a_(p_96562_);
        ConfigScreen.func_238472_a_((MatrixStack)p_96562_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)10, (int)0xFFFFFF);
        super.func_230430_a_(p_96562_, p_96563_, p_96564_, p_96565_);
    }

    public void func_231164_f_() {
        Config.CONFIG.save();
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.parent);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ColorSettingsScreen
    extends Screen {
        @Nullable
        private final Screen parent;
        private ColorList list;

        private ColorSettingsScreen(@Nullable Screen parent) {
            super((ITextComponent)new TranslationTextComponent("damageindicator.config.colorConfig.title"));
            this.parent = parent;
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            double amount = this.list != null ? this.list.func_230966_l_() : 0.0;
            this.list = new ColorList();
            this.list.func_230932_a_(amount);
            this.func_230481_d_((IGuiEventListener)this.list);
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - this.field_230708_k_ / 4, this.field_230709_l_ - 20, this.field_230708_k_ / 2, 20, DialogTexts.field_240632_c_, p_onPress_1_ -> this.func_231175_as__()));
        }

        public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
            this.list.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }

        public void func_231175_as__() {
            this.field_230706_i_.func_147108_a(this.parent);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static class ColorMixingScreen
        extends Screen {
            @Nullable
            private final Screen parent;
            private final Config.ClientConfig.ColorConfig.RGB rgb;
            private Slider red;
            private Slider green;
            private Slider blue;

            private ColorMixingScreen(@Nullable Screen parent, Config.ClientConfig.ColorConfig.RGB rgb) {
                super((ITextComponent)new TranslationTextComponent("damageindicator.config.color." + rgb.path));
                this.parent = parent;
                this.rgb = rgb;
            }

            protected void func_231160_c_() {
                super.func_231160_c_();
                this.red = (Slider)this.func_230480_a_((Widget)new Slider(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 70, this.field_230708_k_ / 2, 20, ITextComponent.func_244388_a((String)"Red: "), StringTextComponent.field_240750_d_, 0.0, 255.0, (double)((Integer)this.rgb.red.get()).intValue(), false, true, p_onPress_1_ -> {}));
                this.green = (Slider)this.func_230480_a_((Widget)new Slider(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 45, this.field_230708_k_ / 2, 20, ITextComponent.func_244388_a((String)"Green: "), StringTextComponent.field_240750_d_, 0.0, 255.0, (double)((Integer)this.rgb.green.get()).intValue(), false, true, p_onPress_1_ -> {}));
                this.blue = (Slider)this.func_230480_a_((Widget)new Slider(this.field_230708_k_ / 4, this.field_230709_l_ / 2 - 20, this.field_230708_k_ / 2, 20, ITextComponent.func_244388_a((String)"Blue: "), StringTextComponent.field_240750_d_, 0.0, 255.0, (double)((Integer)this.rgb.blue.get()).intValue(), false, true, p_onPress_1_ -> {}));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - this.field_230708_k_ / 4, this.field_230709_l_ - 20, this.field_230708_k_ / 2, 20, DialogTexts.field_240632_c_, p_onPress_1_ -> this.func_231175_as__()));
            }

            public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
                this.func_230446_a_(p_230430_1_);
                ColorMixingScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
                int color = MathHelper.func_180181_b((int)this.red.getValueInt(), (int)this.green.getValueInt(), (int)this.blue.getValueInt()) + -16777216;
                this.func_238468_a_(p_230430_1_, this.field_230708_k_ / 4, this.field_230709_l_ / 2 + 5, this.field_230708_k_ * 3 / 4, this.field_230709_l_ - 25, color, color);
                super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            }

            public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
                MutableBoolean mutableBoolean = new MutableBoolean();
                this.func_231039_at__().forEach(iGuiEventListener -> {
                    boolean bl = iGuiEventListener.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
                    if (!mutableBoolean.booleanValue() && bl) {
                        mutableBoolean.setValue(true);
                    }
                });
                return mutableBoolean.booleanValue() || super.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
            }

            public void func_231164_f_() {
                super.func_231164_f_();
                this.rgb.red.set((Object)this.red.getValueInt());
                this.rgb.green.set((Object)this.green.getValueInt());
                this.rgb.blue.set((Object)this.blue.getValueInt());
                Config.CONFIG.save();
            }

            public void func_231175_as__() {
                this.field_230706_i_.func_147108_a(this.parent);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private class ColorList
        extends ExtendedList<Color> {
            public ColorList() {
                super(ColorSettingsScreen.this.field_230706_i_, ColorSettingsScreen.this.field_230708_k_, ColorSettingsScreen.this.field_230709_l_, 20, ColorSettingsScreen.this.field_230709_l_ - 20, 20);
                for (Config.ClientConfig.ColorConfig.RGB rgb : Config.CLIENT.colorConfig.immutable()) {
                    this.func_230513_b_((AbstractList.AbstractListEntry)new Color(rgb));
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            private class Color
            extends ExtendedList.AbstractListEntry<Color> {
                private final Button button;

                private Color(Config.ClientConfig.ColorConfig.RGB rgbConfig) {
                    this.button = new Button(ColorSettingsScreen.this.field_230708_k_ / 4, 0, ColorSettingsScreen.this.field_230708_k_ / 2, 20, (ITextComponent)new TranslationTextComponent("damageindicator.config.color." + rgbConfig.path), p_onPress_1_ -> ColorSettingsScreen.this.field_230706_i_.func_147108_a((Screen)new ColorMixingScreen(ColorSettingsScreen.this, rgbConfig)));
                }

                public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
                    this.button.field_230691_m_ = p_230432_3_;
                    this.button.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
                }

                public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
                    return this.button.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
                }
            }
        }
    }
}

