/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client.renderer;

import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.math.AdditionalMathHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IndicatorRenderer {
    protected static final int maxAge = 20;
    private static final Minecraft mc = Minecraft.func_71410_x();
    protected static final float NORMAL = 1.0f;
    protected static final float CRITICAL = 2.5f;
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;
    protected double x;
    protected double y;
    protected double z;
    protected float velocity;
    protected boolean dead;
    protected int age;
    protected final ITextComponent text;
    protected final String source;
    protected final boolean crit;
    protected int color;
    protected int textWidth = -1;
    protected long startedTickingTimeMs;
    protected final float distance;
    protected final float scaleMultiplier;
    protected float currentScale = Float.NaN;
    protected boolean paused;
    protected long passedTimeMs;
    protected final float fontSize;

    public IndicatorRenderer(double x, double y, double z, ITextComponent text, String source, boolean crit, float distance) {
        this.setPos(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.text = text;
        this.source = source;
        this.crit = crit;
        this.syncIndicatorColor();
        this.distance = distance;
        this.scaleMultiplier = this.crit ? 2.5f : 1.0f;
        this.startedTickingTimeMs = Util.func_211177_b();
        this.fontSize = (float)((Double)Config.CLIENT.fontSize.get()).doubleValue();
    }

    public void tick() {
        this.prevPosX = this.x;
        this.prevPosY = this.y;
        this.prevPosZ = this.z;
        if (this.age++ >= 20) {
            this.markDead();
        } else if (this.age > 10) {
            this.velocity += 0.008f;
            this.velocity *= 0.98f;
            this.moveOnHypotenuse3d(this.velocity);
        } else {
            if (this.currentScale != this.currentScale) {
                this.calculateScale(mc.func_147113_T());
            }
            this.moveOnHypotenuse3d(this.currentScale * 0.5f);
        }
    }

    private void moveOnHypotenuse3d(float lengthOfHypotenuseToMove) {
        if (IndicatorRenderer.mc.func_175598_ae().field_217783_c == null) {
            this.markDead();
        } else {
            float phi = -IndicatorRenderer.mc.func_175598_ae().field_217783_c.func_216778_f() * ((float)Math.PI / 180);
            float theta = IndicatorRenderer.mc.func_175598_ae().field_217783_c.func_216777_e() * ((float)Math.PI / 180);
            float hypotenuse2d = lengthOfHypotenuseToMove * MathHelper.func_76126_a((float)theta);
            this.setPos(this.x + (double)(hypotenuse2d * MathHelper.func_76126_a((float)phi)), this.y + (double)(lengthOfHypotenuseToMove * MathHelper.func_76134_b((float)theta)), this.z + (double)(hypotenuse2d * MathHelper.func_76134_b((float)phi)));
        }
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer vertexConsumers, ActiveRenderInfo camera, float tickDelta) {
        FontRenderer textRenderer = IndicatorRenderer.mc.field_71466_p;
        if (this.textWidth < 0) {
            this.textWidth = textRenderer.func_238414_a_((ITextProperties)this.text);
        }
        if (this.textWidth == 0) {
            this.markDead();
        } else {
            float scale = this.calculateScale(mc.func_147113_T());
            scale *= this.fontSize;
            double x = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPosX, (double)this.x);
            double y = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPosY, (double)this.y);
            double z = MathHelper.func_219803_d((double)tickDelta, (double)this.prevPosZ, (double)this.z);
            Vector3d camPos = camera.func_216785_c();
            double camX = camPos.field_72450_a;
            double camY = camPos.field_72448_b;
            double camZ = camPos.field_72449_c;
            matrix.func_227860_a_();
            matrix.func_227861_a_(x - camX, y - camY, z - camZ);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-camera.func_216778_f()));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(camera.func_216777_e()));
            matrix.func_227862_a_(-scale, -scale, scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            int alpha = 255;
            if (this.age > 10) {
                alpha = (int)((21.0f / (float)this.age - 1.0f) * 255.0f);
            }
            alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
            int color = this.color;
            if (this.age <= 3) {
                color = AdditionalMathHelper.lerpColor((float)(Util.func_211177_b() - this.startedTickingTimeMs) / 150.0f, color);
            }
            float f = (float)(-textRenderer.func_238414_a_((ITextProperties)this.text)) / 2.0f;
            textRenderer.getClass();
            textRenderer.func_243247_a(this.text, f, (float)(-9) / 2.0f, color + (alpha << 24), false, matrix.func_227866_c_().func_227870_a_(), vertexConsumers, true, 0, 0xF000F0);
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            matrix.func_227865_b_();
        }
    }

    private float calculateScale(boolean isPaused) {
        long timeDelta = Util.func_211177_b() - this.startedTickingTimeMs;
        float scale = AdditionalMathHelper.convexUpwardQuadraticFunction(MathHelper.func_76131_a((float)((float)timeDelta / 250.0f), (float)0.0f, (float)1.0f), this.crit ? -0.2f : -0.5f, this.crit ? 2.0f : 0.5f, 0.00375f * this.distance * 1.7320508f * this.scaleMultiplier, 0.0075f * this.distance * 1.7320508f * this.scaleMultiplier * this.scaleMultiplier * (this.crit ? 1.0f : 0.8f));
        scale -= 2.5E-4f * (float)this.textWidth;
        scale = MathHelper.func_76131_a((float)scale, (float)1.0E-4f, (float)Float.MAX_VALUE);
        if (isPaused && !this.paused) {
            this.passedTimeMs = timeDelta;
            this.paused = true;
        } else {
            if (isPaused) {
                return this.currentScale;
            }
            if (this.paused) {
                this.startedTickingTimeMs = Util.func_211177_b() - this.passedTimeMs;
                this.paused = false;
                return this.calculateScale(false);
            }
        }
        this.currentScale = scale;
        return this.currentScale;
    }

    public void markDead() {
        this.dead = true;
    }

    public void syncIndicatorColor() {
        this.color = Config.CLIENT.colorConfig.getRGBFromDamageSource((Boolean)Config.CLIENT.changeColorWhenCrit.get() != false && this.crit ? "critical" : this.source);
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isAlive() {
        return !this.dead;
    }
}

