/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.mixin;

import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.DamageIndicatorPacket;
import com.hamusuke.damageindicator.network.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityInvoker {
    protected int showImmuneCD;
    @Shadow
    protected float field_110153_bc;

    LivingEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Shadow
    public abstract float func_110143_aJ();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.showImmuneCD > 0) {
            --this.showImmuneCD;
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void damage(DamageSource p_21016_, float p_21017_, CallbackInfoReturnable<Boolean> cir) {
        if (!(this instanceof PlayerEntity || this instanceof ShulkerEntity || this instanceof WitherEntity || this.field_70170_p.field_72995_K || cir.getReturnValueZ() || !this.canSendImmune(p_21017_))) {
            this.sendImmune();
        }
    }

    @Override
    public void send(ITextComponent text, String source, boolean crit) {
        if (!this.field_70170_p.field_72995_K) {
            DamageIndicatorPacket damageIndicatorPacket = new DamageIndicatorPacket(this.func_145782_y(), text, source, crit);
            ((ServerWorld)this.field_70170_p).func_217369_A().forEach(serverPlayerEntity -> NetworkManager.sendToClient(damageIndicatorPacket, serverPlayerEntity));
        }
    }

    @Override
    public void sendImmune() {
        this.showImmuneCD = 10;
        this.send((ITextComponent)new TranslationTextComponent("damageindicator.indicator.immune"), "immune", false);
    }

    @Override
    public boolean canSendImmune(float amount) {
        return !(!(this.func_110143_aJ() > 0.0f) || this.showImmuneCD > 0 || (float)this.field_70172_ad > 10.0f && amount <= this.field_110153_bc);
    }
}

