/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator;

import com.hamusuke.damageindicator.client.DamageIndicatorClient;
import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.client.gui.screen.ConfigScreen;
import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.NetworkManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="damageindicator")
public class DamageIndicator {
    public static final String MOD_ID = "damageindicator";

    public DamageIndicator() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CONFIG);
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory(ConfigScreen::new));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new DamageIndicatorClient()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onSetup(FMLCommonSetupEvent event) {
        NetworkManager.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!event.isCanceled() && livingEntity instanceof LivingEntityInvoker) {
            LivingEntityInvoker invoker = (LivingEntityInvoker)livingEntity;
            float amount = Math.min(livingEntity.m_21233_() - livingEntity.m_21223_(), event.getAmount());
            if (!livingEntity.f_19853_.f_46443_ && amount > 0.0f) {
                invoker.send((Component)new TextComponent("+" + Mth.m_14167_((float)amount)), "heal", false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamageLast(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.f_19853_.f_46443_ && livingEntity instanceof LivingEntityInvoker) {
            LivingEntityInvoker invoker = (LivingEntityInvoker)livingEntity;
            DamageSource source = event.getSource();
            boolean bl = false;
            Entity entity = source.m_7639_();
            if (entity instanceof com.hamusuke.criticalib.invoker.LivingEntityInvoker) {
                com.hamusuke.criticalib.invoker.LivingEntityInvoker invoker1 = (com.hamusuke.criticalib.invoker.LivingEntityInvoker)entity;
                bl = invoker1.isCritical();
            }
            invoker.send((Component)new TextComponent("" + Mth.m_14167_((float)event.getAmount())), source.m_19385_(), bl);
        }
    }
}

