/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client.renderer;

import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.math.AdditionalMathHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IndicatorRenderer {
    protected static final int maxAge = 20;
    private static final Minecraft mc = Minecraft.m_91087_();
    protected static final float NORMAL = 1.0f;
    protected static final float CRITICAL = 2.5f;
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;
    protected double x;
    protected double y;
    protected double z;
    protected float velocity;
    protected boolean dead;
    protected int age;
    protected final Component text;
    protected final String source;
    protected final boolean crit;
    protected int color;
    protected int textWidth = -1;
    protected long startedTickingTimeMs;
    protected final float distance;
    protected final float scaleMultiplier;
    protected float currentScale = Float.NaN;
    protected boolean paused;
    protected long passedTimeMs;

    public IndicatorRenderer(double x, double y, double z, Component text, String source, boolean crit, float distance) {
        this.setPos(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        this.text = text;
        this.source = source;
        this.crit = crit;
        this.syncIndicatorColor();
        this.distance = distance;
        this.scaleMultiplier = this.crit ? 2.5f : 1.0f;
        this.startedTickingTimeMs = Util.m_137550_();
    }

    public void tick() {
        this.prevPosX = this.x;
        this.prevPosY = this.y;
        this.prevPosZ = this.z;
        if (this.age++ >= 20) {
            this.markDead();
        } else if (this.age > 10) {
            this.velocity += 0.008f;
            this.velocity *= 0.98f;
            this.moveOnHypotenuse3d(this.velocity);
        } else {
            if (this.currentScale != this.currentScale) {
                this.calculateScale(mc.m_91104_());
            }
            this.moveOnHypotenuse3d(this.currentScale * 0.5f);
        }
    }

    private void moveOnHypotenuse3d(float lengthOfHypotenuseToMove) {
        if (IndicatorRenderer.mc.m_91290_().f_114358_ != null) {
            float phi = (float)((double)(-IndicatorRenderer.mc.m_91290_().f_114358_.m_90590_()) * Math.PI / 180.0);
            float theta = (float)((double)IndicatorRenderer.mc.m_91290_().f_114358_.m_90589_() * Math.PI / 180.0);
            float hypotenuse2d = lengthOfHypotenuseToMove * Mth.m_14031_((float)theta);
            this.setPos(this.x + (double)(hypotenuse2d * Mth.m_14031_((float)phi)), this.y + (double)(lengthOfHypotenuseToMove * Mth.m_14089_((float)theta)), this.z + (double)(hypotenuse2d * Mth.m_14089_((float)phi)));
        }
    }

    public void render(PoseStack matrix, MultiBufferSource.BufferSource bufferSource, Camera camera, float tickDelta) {
        Font font = IndicatorRenderer.mc.f_91062_;
        if (this.textWidth < 0) {
            this.textWidth = font.m_92852_((FormattedText)this.text);
        }
        if (this.textWidth == 0) {
            this.markDead();
        } else {
            float scale = this.calculateScale(mc.m_91104_());
            double x = Mth.m_14139_((double)tickDelta, (double)this.prevPosX, (double)this.x);
            double y = Mth.m_14139_((double)tickDelta, (double)this.prevPosY, (double)this.y);
            double z = Mth.m_14139_((double)tickDelta, (double)this.prevPosZ, (double)this.z);
            Vec3 camPos = camera.m_90583_();
            double camX = camPos.f_82479_;
            double camY = camPos.f_82480_;
            double camZ = camPos.f_82481_;
            matrix.m_85836_();
            matrix.m_85837_(x - camX, y - camY, z - camZ);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-camera.m_90590_()));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
            matrix.m_85841_(-scale, -scale, scale);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)false);
            int alpha = 255;
            if (this.age > 10) {
                alpha = (int)((21.0f / (float)this.age - 1.0f) * 255.0f);
            }
            alpha = Mth.m_14045_((int)alpha, (int)0, (int)255);
            int color = this.color;
            if (this.age <= 3) {
                color = AdditionalMathHelper.lerpColor((float)(Util.m_137550_() - this.startedTickingTimeMs) / 150.0f, color);
            }
            float f = (float)(-font.m_92852_((FormattedText)this.text)) / 2.0f;
            Objects.requireNonNull(font);
            font.m_92841_(this.text, f, (float)(-9) / 2.0f, color + (alpha << 24), false, matrix.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, true, 0, 0xF000F0);
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)true);
            matrix.m_85849_();
        }
    }

    private float calculateScale(boolean isPaused) {
        long timeDelta = Util.m_137550_() - this.startedTickingTimeMs;
        float scale = AdditionalMathHelper.convexUpwardQuadraticFunction(Mth.m_14036_((float)((float)timeDelta / 250.0f), (float)0.0f, (float)1.0f), this.crit ? -0.2f : -0.5f, this.crit ? 2.0f : 0.5f, 0.00375f * this.distance * 1.7320508f * this.scaleMultiplier, 0.0075f * this.distance * 1.7320508f * this.scaleMultiplier * this.scaleMultiplier * (this.crit ? 1.0f : 0.8f));
        scale -= 2.5E-4f * (float)this.textWidth;
        scale = Mth.m_14036_((float)scale, (float)1.0E-4f, (float)Float.MAX_VALUE);
        if (isPaused && !this.paused) {
            this.passedTimeMs = timeDelta;
            this.paused = true;
        } else {
            if (isPaused) {
                return this.currentScale;
            }
            if (this.paused) {
                this.startedTickingTimeMs = Util.m_137550_() - this.passedTimeMs;
                this.paused = false;
                return this.calculateScale(false);
            }
        }
        this.currentScale = scale;
        return this.currentScale;
    }

    public void markDead() {
        this.dead = true;
    }

    public void syncIndicatorColor() {
        this.color = Config.CLIENT.colorConfig.getRGBFromDamageSource((Boolean)Config.CLIENT.changeColorWhenCrit.get() != false && this.crit ? "critical" : this.source);
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isAlive() {
        return !this.dead;
    }
}

