/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.mixin;

import com.hamusuke.damageindicator.invoker.LivingEntityInvoker;
import com.hamusuke.damageindicator.network.DamageIndicatorPacket;
import com.hamusuke.damageindicator.network.NetworkManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityInvoker {
    protected int showImmuneCD;
    @Shadow
    protected float f_20898_;

    LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract float m_21223_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.showImmuneCD > 0) {
            --this.showImmuneCD;
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void damage(DamageSource p_21016_, float p_21017_, CallbackInfoReturnable<Boolean> cir) {
        if (!(this instanceof Player || this instanceof Shulker || this instanceof WitherBoss || this.f_19853_.f_46443_ || cir.getReturnValueZ() || !this.canSendImmune(p_21017_))) {
            this.sendImmune();
        }
    }

    @Override
    public void send(Component text, String source, boolean crit) {
        if (!this.f_19853_.f_46443_) {
            DamageIndicatorPacket damageIndicatorPacket = new DamageIndicatorPacket(this.m_142049_(), text, source, crit);
            ((ServerLevel)this.f_19853_).m_6907_().forEach(serverPlayerEntity -> NetworkManager.sendToClient(damageIndicatorPacket, serverPlayerEntity));
        }
    }

    @Override
    public void sendImmune() {
        this.showImmuneCD = 10;
        this.send((Component)new TranslatableComponent("damageindicator.indicator.immune"), "immune", false);
    }

    @Override
    public boolean canSendImmune(float amount) {
        return !(!(this.m_21223_() > 0.0f) || this.showImmuneCD > 0 || (float)this.f_19802_ > 10.0f && amount <= this.f_20898_);
    }
}

