/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.damageindicator.client;

import com.google.common.collect.Queues;
import com.hamusuke.damageindicator.client.config.Config;
import com.hamusuke.damageindicator.client.renderer.IndicatorRenderer;
import java.util.Queue;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class DamageIndicatorClient {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final Queue<IndicatorRenderer> queue = Queues.newLinkedBlockingDeque();
    private static DamageIndicatorClient INSTANCE;
    private static final KeyMapping hideIndicator;

    public DamageIndicatorClient() {
        INSTANCE = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyMappings);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
    }

    private void onConfigReload(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("damageindicator")) {
            this.queue.forEach(IndicatorRenderer::syncIndicatorColor);
        }
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(hideIndicator);
    }

    @SubscribeEvent
    public void onInputKey(InputEvent.Key event) {
        if (hideIndicator.m_90859_()) {
            Config.CLIENT.hideIndicator.set((Object)((Boolean)Config.CLIENT.hideIndicator.get() == false ? 1 : 0));
        }
    }

    @SubscribeEvent
    public void onEndTick(TickEvent.ClientTickEvent event) {
        if (!mc.m_91104_() && event.phase == TickEvent.Phase.END) {
            this.queue.forEach(IndicatorRenderer::tick);
            this.queue.removeIf(IndicatorRenderer::isDead);
        }
    }

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!((Boolean)Config.CLIENT.hideIndicator.get()).booleanValue() && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && !this.queue.isEmpty()) {
            mc.m_91307_().m_6180_("damage indicator rendering");
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            this.queue.forEach(indicatorRenderer -> indicatorRenderer.render(bufferSource, DamageIndicatorClient.mc.m_91290_().f_114358_, event.getPartialTick()));
            bufferSource.m_109911_();
            mc.m_91307_().m_7238_();
        }
    }

    public void addRenderer(int entityId, Component text, String source, boolean crit) {
        Entity clientEntity;
        if (DamageIndicatorClient.mc.f_91073_ != null && DamageIndicatorClient.mc.f_91074_ != null && (clientEntity = DamageIndicatorClient.mc.f_91073_.m_6815_(entityId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)clientEntity;
            double x = clientEntity.m_20208_(0.5);
            double y = clientEntity.m_20227_(Mth.m_216263_((RandomSource)livingEntity.m_217043_(), (double)0.5, (double)1.2));
            double z = clientEntity.m_20262_(0.5);
            Vec3 vec3 = new Vec3(x, y, z);
            float distance = (float)DamageIndicatorClient.mc.f_91063_.m_109153_().m_90583_().m_82554_(vec3);
            BlockHitResult result = DamageIndicatorClient.mc.f_91073_.m_45547_(new ClipContext(DamageIndicatorClient.mc.f_91074_.m_20182_(), vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if ((((Boolean)Config.CLIENT.forceIndicatorRendering.get()).booleanValue() || result.m_6662_() == HitResult.Type.MISS) && distance <= (float)((Integer)Config.CLIENT.renderDistance.get()).intValue()) {
                this.queue.add(new IndicatorRenderer(x, y, z, text, source, crit, distance));
            }
        }
    }

    public static DamageIndicatorClient getInstance() {
        return INSTANCE;
    }

    static {
        hideIndicator = new KeyMapping("key.damageindicator.hideIndicator.desc", -1, "key.damageindicator.category.indicator");
    }
}

