/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.damagetilt.asm;

import com.charles445.damagetilt.asm.helper.ASMHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DamageTiltASM
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            return this.transformEntityLivingBase(basicClass);
        }
        return basicClass;
    }

    public byte[] transformEntityLivingBase(byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        for (MethodNode mNode : classNode.methods) {
            if (!mNode.name.equals("func_70653_a") && !mNode.name.equals("knockBack")) continue;
            System.out.println("DamageTilt Found matching method " + mNode.name);
            if (!mNode.desc.equals("(Lnet/minecraft/entity/Entity;FDD)V")) continue;
            System.out.println("DamageTilt Matching method has matching desc");
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "com/charles445/damagetilt/EventHandler", "onKnockback", "(Lnet/minecraft/entity/EntityLivingBase;)V", false));
            mNode.instructions.insertBefore(ASMHelper.findFirstInstruction(mNode), list);
            System.out.println("DamageTilt Patched method " + mNode.name);
            return ASMHelper.writeClassToBytes(classNode, 1);
        }
        return basicClass;
    }
}

