/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1548;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import tech.thatgravyboat.creeperoverhaul.common.utils.PlatformUtils;

public record CreeperType(class_2960 texture, class_2960 glowingTexture, class_2960 chargedTexture, class_2960 model, class_2960 shearedModel, class_2960 animation, int melee, Map<Predicate<class_2680>, Function<class_5819, class_2680>> replacer, Collection<class_1299<?>> entitiesAfraidOf, Collection<class_1293> inflictingPotions, Collection<class_1293> potionsWhenDead, Collection<Class<? extends class_1309>> entities, Collection<class_1282> immunities, class_5132 attributes, boolean shearable, Supplier<class_3414> deathSound, Supplier<class_3414> explosionSound, Supplier<class_3414> hitSound, Supplier<class_3414> hurtSound, Supplier<class_3414> primeSound) {
    public Optional<class_3414> getDeathSound() {
        return Optional.ofNullable(this.deathSound.get());
    }

    public Optional<class_3414> getExplosionSound() {
        return Optional.ofNullable(this.explosionSound.get());
    }

    public Optional<class_3414> getHitSound() {
        return Optional.ofNullable(this.hitSound.get());
    }

    public Optional<class_3414> getHurtSound() {
        return Optional.ofNullable(this.hurtSound.get());
    }

    public Optional<class_3414> getPrimeSound() {
        return Optional.ofNullable(this.primeSound.get());
    }

    public static class Builder {
        private class_2960 texture;
        private class_2960 glowingTexture;
        private class_2960 chargedTexture;
        private class_2960 model;
        private class_2960 shearedModel;
        private class_2960 animation;
        private int melee = 0;
        private final List<class_1299<?>> afraidOf = new ArrayList();
        private final List<class_1293> inflictingPotions = new ArrayList<class_1293>();
        private final List<class_1293> potionsWhenDying = new ArrayList<class_1293>();
        private final List<Class<? extends class_1309>> attackingEntities = new ArrayList<Class<? extends class_1309>>();
        private final List<class_1282> immunities = new ArrayList<class_1282>();
        private final Map<Predicate<class_2680>, Function<class_5819, class_2680>> replacer = new HashMap<Predicate<class_2680>, Function<class_5819, class_2680>>();
        private final class_5132.class_5133 attributes = class_1548.method_26908().method_26868(PlatformUtils.getModAttribute("reach_distance"), 0.0).method_26867(PlatformUtils.getModAttribute("swim_speed"));
        private boolean shearable;
        private Supplier<class_3414> deathSound = () -> class_3417.field_14907;
        private Supplier<class_3414> explosionSound = () -> null;
        private Supplier<class_3414> hitSound = () -> null;
        private Supplier<class_3414> hurtSound = () -> class_3417.field_15192;
        private Supplier<class_3414> primeSound = () -> class_3417.field_15057;

        public Builder setTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public Builder setGlowingTexture(class_2960 glowingTexture) {
            this.glowingTexture = glowingTexture;
            return this;
        }

        public Builder setChargedTexture(class_2960 chargedTexture) {
            this.chargedTexture = chargedTexture;
            return this;
        }

        public Builder setModel(class_2960 model) {
            this.model = model;
            return this;
        }

        public Builder setShearedModel(class_2960 shearedModel) {
            this.shearedModel = shearedModel;
            return this;
        }

        public Builder setAnimation(class_2960 animation) {
            this.animation = animation;
            return this;
        }

        public Builder setMelee(int melee) {
            this.melee = melee;
            return this;
        }

        public Builder addReplacer(Predicate<class_2680> predicate, Function<class_5819, class_2680> function) {
            this.replacer.put(predicate, function);
            return this;
        }

        public Builder addAfraidOf(class_1299<?> entity) {
            this.afraidOf.add(entity);
            return this;
        }

        public Builder addInflictingPotion(class_1293 potion) {
            this.inflictingPotions.add(potion);
            return this;
        }

        public Builder addPotionsWhenDying(class_1293 potion) {
            this.potionsWhenDying.add(potion);
            return this;
        }

        public Builder addAttackingEntities(Class<? extends class_1309> attackingEntities) {
            this.attackingEntities.add(attackingEntities);
            return this;
        }

        public Builder addImmunity(class_1282 source) {
            this.immunities.add(source);
            return this;
        }

        public Builder addAttribute(String attribute, double value) {
            class_1320 modAttribute = PlatformUtils.getModAttribute(attribute);
            if (modAttribute == null) {
                throw new IllegalArgumentException("Mod Attribute " + attribute + " does not exist");
            }
            this.attributes.method_26868(modAttribute, value);
            return this;
        }

        public Builder addAttribute(class_1320 attribute, double value) {
            this.attributes.method_26868(attribute, value);
            return this;
        }

        public Builder setShearable(boolean shearable) {
            this.shearable = shearable;
            return this;
        }

        public Builder setDeathSounds(Supplier<class_3414> sound) {
            this.deathSound = sound;
            return this;
        }

        public Builder setExplosionSounds(Supplier<class_3414> sound) {
            this.explosionSound = sound;
            return this;
        }

        public Builder setHitSounds(Supplier<class_3414> sound) {
            this.hitSound = sound;
            return this;
        }

        public Builder setHurtSounds(Supplier<class_3414> sound) {
            this.hurtSound = sound;
            return this;
        }

        public Builder setPrimeSounds(Supplier<class_3414> sound) {
            this.primeSound = sound;
            return this;
        }

        public CreeperType build() {
            return new CreeperType(this.texture, this.glowingTexture, this.chargedTexture, this.model, this.shearedModel, this.animation, this.melee, this.replacer, this.afraidOf, this.inflictingPotions, this.potionsWhenDying, this.attackingEntities, this.immunities, this.attributes.method_26866(), this.shearable, this.deathSound, this.explosionSound, this.hitSound, this.hurtSound, this.primeSound);
        }
    }
}

