/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import org.apache.commons.io.FileUtils;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonObject DEFAULT_CONFIG = (JsonObject)class_156.method_654((Object)new JsonObject(), json -> {
        json.addProperty("//replaceDefaultCreeper", "Change the Vanilla Creeper to a new and improved texture with better animations.");
        json.addProperty("replaceDefaultCreeper", Boolean.valueOf(true));
        json.addProperty("//destroyBlocks", "Change the Creeper Overhaul creepers to destroy blocks or not.");
        json.addProperty("destroyBlocks", Boolean.valueOf(true));
    });
    public static boolean replaceDefaultCreeper = true;
    public static boolean destroyBlocks = true;

    public static void loadConfig() throws IOException {
        Path cfgPath = FabricLoader.getInstance().getConfigDir();
        File cfgFile = new File(cfgPath.toFile(), "creeperoverhaul.json");
        if (!cfgFile.exists()) {
            cfgPath.toFile().mkdirs();
            FileUtils.write((File)cfgFile, (CharSequence)GSON.toJson((JsonElement)DEFAULT_CONFIG), (Charset)StandardCharsets.UTF_8);
        } else {
            JsonObject cfgJson = (JsonObject)GSON.fromJson(FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8), JsonObject.class);
            if (cfgJson != null) {
                replaceDefaultCreeper = !cfgJson.has("replaceDefaultCreeper") || cfgJson.get("replaceDefaultCreeper").getAsBoolean();
                destroyBlocks = !cfgJson.has("destroyBlocks") || cfgJson.get("destroyBlocks").getAsBoolean();
            }
        }
    }
}

