/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.fabric;

import java.util.HashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.mixin.object.builder.DefaultAttributeRegistryAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import tech.thatgravyboat.creeperoverhaul.Creepers;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSpawns;
import tech.thatgravyboat.creeperoverhaul.common.registry.fabric.FabricAttributes;
import tech.thatgravyboat.creeperoverhaul.fabric.Config;

public class CreepersFabric
implements ModInitializer {
    public void onInitialize() {
        try {
            Config.loadConfig();
        }
        catch (Exception e) {
            System.out.println("[Creeper Overhaul] Failed to load Config.");
        }
        Creepers.init();
        FabricAttributes.register();
        HashMap<class_1299<? extends class_1309>, class_5132> attributes = new HashMap<class_1299<? extends class_1309>, class_5132>();
        Creepers.registerAttributes(attributes);
        attributes.forEach(DefaultAttributeRegistryAccessor.getRegistry()::put);
        this.addCreepers();
        this.removeCreepers();
        ModSpawns.addSpawnRules();
    }

    public void addCreepers() {
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36510), ModEntities.BEACH_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36510), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.isSnowing(), ModEntities.SNOWY_CREEPER);
        this.addCreeper(CreepersFabric.isSnowing(), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36520), ModEntities.DESERT_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36520), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36514), ModEntities.HILLS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36514), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_37392), ModEntities.SAVANNAH_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_37392), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36524), ModEntities.BADLANDS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36524), ModEntities.CAVE_CREEPER);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462}), (class_1311)class_1311.field_6294, ModEntities.MUSHROOM_CREEPER.get(), (int)10, (int)1, (int)2);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36515), ModEntities.SPRUCE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36515), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36512).and(Predicate.not(CreepersFabric.isSnowing())), ModEntities.HILLS_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36512), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_28107, class_1972.field_29218}), ModEntities.DRIPSTONE_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_28107, class_1972.field_29218}), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36516), ModEntities.BAMBOO_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36516), ModEntities.JUNGLE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36516), ModEntities.CAVE_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36532), ModEntities.SWAMP_CREEPER);
        this.addCreeper(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36532), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}), ModEntities.DARK_OAK_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}), ModEntities.CAVE_CREEPER);
    }

    public void removeCreepers() {
        Predicate<BiomeSelectionContext> creepersToRemove = CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36510).or(CreepersFabric.isSnowing()).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36520)).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36514)).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_37392)).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36524)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9462})).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36515)).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36512)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_28107, class_1972.field_29218})).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36516)).or(CreepersFabric.tag((class_6862<class_1959>)class_6908.field_36532)).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}));
        this.removeCreeper(creepersToRemove);
    }

    private static Predicate<BiomeSelectionContext> tag(class_6862<class_1959> tag) {
        return BiomeSelectors.tag(tag);
    }

    private static Predicate<BiomeSelectionContext> isSnowing() {
        return ctx -> ctx.getBiome().method_8694().equals((Object)class_1959.class_1963.field_9383);
    }

    private <E extends BaseCreeper> void addCreeper(Predicate<BiomeSelectionContext> selectors, Supplier<class_1299<E>> entityType) {
        BiomeModifications.addSpawn(selectors.and(BiomeSelectors.foundInOverworld()), (class_1311)entityType.get().method_5891(), entityType.get(), (int)75, (int)2, (int)2);
    }

    private void removeCreeper(Predicate<BiomeSelectionContext> biomeSelector) {
        class_2960 id = class_2378.field_11145.method_10221((Object)class_1299.field_6046);
        BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector, context -> context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6046));
    }
}

