/*
 * Decompiled with CFR 0.152.
 */
package shadowmaster435.impactfulweather.client.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import shadowmaster435.impactfulweather.BiomeParticleWeather;
import shadowmaster435.impactfulweather.client.core.ClientRegistration;
import shadowmaster435.impactfulweather.client.core.init.builder.ModSpriteParticleRegistration;
import shadowmaster435.impactfulweather.core.init.RegistryReference;

public class ForgeClientRegistration
implements ClientRegistration {
    private final Set<IEventBus> modEventBuses = Sets.newIdentityHashSet();
    private final List<Pair<RegistryReference<? extends ParticleType<? extends ParticleOptions>>, ParticleProvider<?>>> particleProviders = Lists.newArrayList();
    private final List<Pair<RegistryReference<? extends ParticleType<? extends ParticleOptions>>, ModSpriteParticleRegistration<?>>> spriteParticleFactories = Lists.newArrayList();

    @Override
    public <T extends ParticleOptions> void registerParticleProvider(RegistryReference<? extends ParticleType<T>> type, ParticleProvider<T> provider) {
        this.registerModEventBus();
        this.particleProviders.add(Pair.of(type, provider));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleProvider(RegistryReference<? extends ParticleType<T>> type, ModSpriteParticleRegistration<T> factory) {
        this.registerModEventBus();
        this.spriteParticleFactories.add(Pair.of(type, factory));
    }

    @SubscribeEvent
    public void onRegisterParticleProviders(ParticleFactoryRegisterEvent evt) {
        this.particleProviders.forEach(pair -> Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)((RegistryReference)pair.left()).get(), (ParticleProvider)pair.right()));
        this.spriteParticleFactories.forEach(pair -> Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)((RegistryReference)pair.left()).get(), spriteSet -> ((ModSpriteParticleRegistration)pair.right()).create(spriteSet)));
    }

    private void registerModEventBus() {
        if (this.modEventBuses.add(FMLJavaModLoadingContext.get().getModEventBus())) {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
            BiomeParticleWeather.LOGGER.info("Added listener to client registration of mod {}", (Object)ModLoadingContext.get().getActiveNamespace());
        }
    }
}

