/*
 * Decompiled with CFR 0.152.
 */
package shadowmaster435.impactfulweather.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import shadowmaster435.impactfulweather.client.util.ParticleUtil;
import shadowmaster435.impactfulweather.config.ClientConfig;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Unique
    private static final ResourceLocation BLANK_WEATHER_LOCATION = new ResourceLocation("impactfulweather", "textures/misc/blank.png");
    @Shadow
    private int f_109477_;
    @Shadow
    private int f_109450_;

    @Inject(at={@At(value="HEAD")}, method={"renderLevel"})
    private void impactfulweather$renderLevel(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
    }

    @Inject(at={@At(value="HEAD")}, method={"renderSnowAndRain"})
    private void impactfulweather$renderSnowAndRain(LightTexture manager, float f, double d, double e, double g, CallbackInfo ci) {
        ParticleUtil.spawnweatherparticles();
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void impactfulweather$tick(CallbackInfo ci) {
        ParticleUtil.netherweatherlogic();
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V", shift=At.Shift.AFTER)})
    private void impactfulweather$renderSnowAndRain(CallbackInfo ci) {
        if (!((Boolean)ClientConfig.INSTANCE.misc.renderedweather.get()).booleanValue()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)BLANK_WEATHER_LOCATION);
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void impactfulweather$tickRain(Camera camera, CallbackInfo callback) {
        callback.cancel();
        Minecraft client = Minecraft.m_91087_();
        float f = client.f_91073_.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            Random random = new Random((long)this.f_109477_ * 312987231L);
            ClientLevel worldView = client.f_91073_;
            BlockPos blockPos = new BlockPos(camera.m_90583_());
            BlockPos blockPos2 = null;
            int i = (int)(100.0f * f * f) / (client.f_91066_.f_92073_ == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                SimpleParticleType particleEffect;
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockPos3 = worldView.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos.m_142082_(k, 0, l));
                Biome biome = (Biome)worldView.m_204166_(blockPos3).m_203334_();
                if (blockPos3.m_123342_() <= worldView.m_141937_() || blockPos3.m_123342_() > blockPos.m_123342_() + 10 || blockPos3.m_123342_() < blockPos.m_123342_() - 10 || biome.m_47530_() != Biome.Precipitation.RAIN || !biome.m_198906_(blockPos3)) continue;
                blockPos2 = blockPos3.m_7495_();
                if (client.f_91066_.f_92073_ == ParticleStatus.MINIMAL) break;
                double d = random.nextDouble();
                double e = random.nextDouble();
                BlockState blockState = worldView.m_8055_(blockPos2);
                FluidState fluidState = worldView.m_6425_(blockPos2);
                VoxelShape voxelShape = blockState.m_60812_((BlockGetter)worldView, blockPos2);
                double g = voxelShape.m_83290_(Direction.Axis.Y, d, e);
                double h = fluidState.m_76155_((BlockGetter)worldView, blockPos2);
                double m = Math.max(g, h);
                SimpleParticleType simpleParticleType = particleEffect = !fluidState.m_205070_(FluidTags.f_13132_) && !blockState.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockState) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
                if (!((Boolean)ClientConfig.INSTANCE.misc.renderedweather.get()).booleanValue()) continue;
                client.f_91073_.m_7106_((ParticleOptions)particleEffect, (double)blockPos2.m_123341_() + d, (double)blockPos2.m_123342_() + m, (double)blockPos2.m_123343_() + e, 0.0, 0.0, 0.0);
            }
            if (blockPos2 != null && random.nextInt(3) < this.f_109450_++) {
                this.f_109450_ = 0;
                if (blockPos2.m_123342_() > blockPos.m_123342_() + 1 && worldView.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > Mth.m_14143_((float)blockPos.m_123342_())) {
                    client.f_91073_.m_104677_(blockPos2, SoundEvents.f_12542_, SoundSource.WEATHER, 0.1f, 0.5f, false);
                } else {
                    client.f_91073_.m_104677_(blockPos2, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }
}

