/*
 * Decompiled with CFR 0.152.
 */
package shadowmaster435.impactfulweather.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MiscUtil {
    public static BlockHitResult getBlockHitResult(Level world, LivingEntity placer) {
        return world.m_45547_(new ClipContext(placer.m_146892_(), placer.m_19907_(4.0, Minecraft.m_91087_().m_91296_(), false).m_82450_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)placer));
    }

    public static boolean forloopdecimalizer(double modifier, float delta) {
        float remainder = (float)Math.abs(modifier - Math.ceil(modifier));
        int decimalplace = Integer.parseInt("1" + "0".repeat(String.valueOf(modifier).length() - 2));
        double floatresult = modifier * (double)(remainder + 1.0f);
        return (double)delta - floatresult >= 0.0;
    }

    public static boolean IsBlockAtPos(Block block, BlockPos pos, Level world) {
        return world.m_8055_(pos).m_60734_() == block;
    }

    public static ClipContext getRaycastContext(Level world, LivingEntity placer) {
        return new ClipContext(placer.m_146892_(), placer.m_19907_(4.0, Minecraft.m_91087_().m_91296_(), false).m_82450_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)placer);
    }

    public static List<BlockPos> getSurfacePosArray(BlockPos pos, Level world, BlockState[] blockStates, int poslimit) {
        ArrayList<BlockPos> poslist = new ArrayList<BlockPos>();
        List<BlockState> templist = Arrays.stream(blockStates).toList();
        for (int x2 = 1; x2 < 32; ++x2) {
            for (int y2 = 1; y2 < 32; ++y2) {
                for (int z2 = 1; z2 < 32; ++z2) {
                    int zps;
                    int yps;
                    int xps = pos.m_123341_() - 16 + x2;
                    if (!templist.contains(world.m_8055_(new BlockPos(xps, yps = pos.m_123342_() - 16 + y2, zps = pos.m_123343_() - 16 + z2))) || !world.m_46859_(new BlockPos(xps, yps + 1, zps)) || !world.m_45527_(new BlockPos(xps, yps, zps))) continue;
                    poslist.add(new BlockPos(xps, yps, zps));
                }
            }
        }
        return poslist;
    }

    public static int RandomIntseed(Random random, int mult) {
        return random.nextInt() * mult;
    }

    public static Vec3 RayLerpPos(double delta, Level world, Vec3 start, Vec3 end) {
        double x = Mth.m_14139_((double)delta, (double)start.f_82479_, (double)end.f_82479_);
        double y = Mth.m_14139_((double)delta, (double)start.f_82480_, (double)end.f_82480_);
        double z = Mth.m_14139_((double)delta, (double)start.f_82481_, (double)end.f_82481_);
        return new Vec3(x, y, z);
    }

    public static float makeUnInt(float maxval, float val) {
        return val > 0.0f ? maxval / val : 0.0f;
    }

    public static float getRealLightLevel(ClientLevel world, BlockPos pos) {
        int blocklight = world.m_45517_(LightLayer.BLOCK, pos);
        int timelight = 0;
        int skylight = world.m_46471_() ? 2 : (world.m_46470_() ? 4 : 0);
        if (world.m_46467_() > 1000L && world.m_46467_() < 12000L) {
            timelight = 15;
        } else if (world.m_46467_() > 13000L && world.m_46467_() < 23000L) {
            timelight = 6;
        } else if (world.m_46467_() < 1000L && world.m_46467_() > 0L || world.m_46467_() < 13000L && world.m_46467_() > 12000L) {
            timelight = 12;
        }
        int gammaval = (int)Math.floor((Double)Minecraft.m_91087_().f_91066_.m_231927_().m_231551_() * 3.0);
        int light = blocklight < 3 ? Math.abs(timelight - skylight + gammaval) : Math.abs(Math.max(timelight - skylight, blocklight)) + gammaval;
        return Math.max(light, 0);
    }

    public static Vec3 AreaLerpPosRand(Vec3 vec3d, double xsize, double ysize, double zsize) {
        double x = xsize - xsize * 0.5;
        double y = xsize - ysize * 0.5;
        double z = xsize - zsize * 0.5;
        double xneg = xsize - xsize * 0.5 * -1.0;
        double yneg = xsize - ysize * 0.5 * -1.0;
        double zneg = xsize - zsize * 0.5 * -1.0;
        return new Vec3(Mth.m_14139_((double)MiscUtil.RandomDouble(1.0), (double)x, (double)xneg), Mth.m_14139_((double)MiscUtil.RandomDouble(1.0), (double)y, (double)yneg), Mth.m_14139_((double)MiscUtil.RandomDouble(1.0), (double)z, (double)zneg));
    }

    public static boolean ifchance(int percent) {
        return Math.random() * 100.0 > (double)percent;
    }

    public static int RandomInt(int mult) {
        return (int)(Math.random() * (double)mult);
    }

    public static double RandomDoubleSeeded(Random random, double mult) {
        return random.nextDouble() * mult;
    }

    public static double RandomDouble(double mult) {
        return Math.random() * mult;
    }

    public static float RandomFloatSeeded(Random random, float mult) {
        return random.nextFloat() * mult;
    }

    public static float RandomFloat(float mult) {
        return (float)Math.random() * mult;
    }
}

