/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.forge;

import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.thatgravyboat.creeperoverhaul.Creepers;
import tech.thatgravyboat.creeperoverhaul.client.CreepersClient;
import tech.thatgravyboat.creeperoverhaul.client.forge.ClientConfig;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModBlocks;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSpawns;
import tech.thatgravyboat.creeperoverhaul.common.registry.forge.ModBlocksImpl;
import tech.thatgravyboat.creeperoverhaul.common.registry.forge.ModEntitiesImpl;
import tech.thatgravyboat.creeperoverhaul.common.registry.forge.ModItemsImpl;
import tech.thatgravyboat.creeperoverhaul.common.registry.forge.ModSoundsImpl;
import tech.thatgravyboat.creeperoverhaul.forge.CommonConfig;

@Mod(value="creeperoverhaul")
public class CreepersForge {
    public CreepersForge() {
        Creepers.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItemsImpl.ITEMS.register(bus);
        ModBlocksImpl.BLOCKS.register(bus);
        ModEntitiesImpl.ENTITIES.register(bus);
        ModSoundsImpl.SOUNDS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        bus.addListener(this::onAttributes);
        bus.addListener(this::onClient);
        bus.addListener(this::onComplete);
        bus.addListener(this::onCommonSetup);
    }

    public void onAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();
        Creepers.registerAttributes(attributes);
        attributes.forEach((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    public void onComplete(FMLLoadCompleteEvent event) {
        ModSpawns.addSpawnRules();
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation("creeperoverhaul", "tiny_cactus"), ModBlocks.POTTED_TINY_CACTUS);
    }

    public void onClient(FMLClientSetupEvent event) {
        CreepersClient.registerRenderers();
    }
}

