/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public class CreeperAvoidEntitiesGoal
extends Goal {
    private final BaseCreeper creeper;
    private final float maxDistance;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    private Entity entityToAvoid;
    @Nullable
    private Path path;

    public CreeperAvoidEntitiesGoal(BaseCreeper creeper, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
        this.creeper = creeper;
        this.maxDistance = maxDistance;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        List afraidEntities = this.creeper.f_19853_.m_6249_((Entity)this.creeper, this.creeper.m_20191_().m_82377_((double)this.maxDistance, 3.0, (double)this.maxDistance), this::isAfraidOf);
        this.entityToAvoid = this.getNearestEntity(afraidEntities, (Entity)this.creeper);
        if (this.entityToAvoid == null) {
            return false;
        }
        Vec3 posAway = DefaultRandomPos.m_148407_((PathfinderMob)this.creeper, (int)16, (int)7, (Vec3)this.entityToAvoid.m_20182_());
        if (posAway == null) {
            return false;
        }
        if (this.entityToAvoid.m_20238_(posAway) < this.entityToAvoid.m_20280_((Entity)this.creeper)) {
            return false;
        }
        this.path = this.creeper.m_21573_().m_26524_(posAway.f_82479_, posAway.f_82480_, posAway.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.creeper.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.creeper.m_21573_().m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.entityToAvoid = null;
    }

    public void m_8037_() {
        if (this.entityToAvoid != null) {
            this.creeper.m_21573_().m_26517_(this.creeper.m_20280_(this.entityToAvoid) < 49.0 ? this.sprintSpeedModifier : this.walkSpeedModifier);
        }
    }

    @Nullable
    private Entity getNearestEntity(List<Entity> entities, Entity self) {
        if (entities.isEmpty()) {
            return null;
        }
        double lastDist = -1.0;
        Entity lastEntity = null;
        for (Entity entity : entities) {
            double dist = entity.m_20275_(self.m_20185_(), self.m_20186_(), self.m_20189_());
            if (lastDist != -1.0 && !(dist < lastDist)) continue;
            lastEntity = entity;
            lastDist = dist;
        }
        return lastEntity;
    }

    public boolean isAfraidOf(Entity entity) {
        return this.creeper.type.entitiesAfraidOf().contains(entity.m_6095_());
    }
}

