/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.sprout.client.BounceBugBottleBlockEntityRenderer;
import tech.thatgravyboat.sprout.client.FlowerBoxBlockEntityRenderer;
import tech.thatgravyboat.sprout.client.ShootParticle;
import tech.thatgravyboat.sprout.client.SnoozeParticle;
import tech.thatgravyboat.sprout.client.entity.BounceBugEntityRenderer;
import tech.thatgravyboat.sprout.client.entity.ElephantEntityModel;
import tech.thatgravyboat.sprout.client.entity.MobEntityRenderer;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;
import tech.thatgravyboat.sprout.common.flowers.FlowerColor;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;
import tech.thatgravyboat.sprout.common.registry.SproutBlocks;
import tech.thatgravyboat.sprout.common.registry.SproutEntities;
import tech.thatgravyboat.sprout.common.registry.SproutFlowers;
import tech.thatgravyboat.sprout.common.registry.SproutItems;
import tech.thatgravyboat.sprout.common.registry.SproutParticles;
import tech.thatgravyboat.sprout.forge.SproutClientImpl;

@OnlyIn(value=Dist.CLIENT)
public class SproutClient {
    public static void init() {
        SproutClient.renderBlockRenderers(SproutBlocks.PEANUT_PLANT_BLOCK, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.BOUNCE_BUG_BOTTLE, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.CATTIAL, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.TALL_DEAD_BUSH, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.WATER_LENTIL, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.SPROUTS, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.DUNE_GRASS, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.RED_SHELF_FUNGI, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.BROWN_SHELF_FUNGI, RenderType.m_110463_());
        SproutClient.renderBlockRenderers(SproutBlocks.DUNE_GRASS, RenderType.m_110463_());
        for (Map.Entry<FlowerColor, Map<FlowerType, Supplier<Block>>> entry : SproutFlowers.FLOWERS.entrySet()) {
            for (Map.Entry<FlowerType, Supplier<Block>> flower : entry.getValue().entrySet()) {
                if (entry.getKey().bannedTypes.contains((Object)flower.getKey())) continue;
                SproutClient.renderBlockRenderers(flower.getValue(), RenderType.m_110463_());
            }
        }
        SproutFlowers.POTTED_FLOWERS.forEach(value -> SproutClient.renderBlockRenderers(value, RenderType.m_110463_()));
        SproutClient.registerEntityRenderer(SproutEntities.ELEPHANT_ENTITY_TYPE, ctx -> new MobEntityRenderer<ElephantEntity>(ctx, new ElephantEntityModel()));
        SproutClient.registerEntityRenderer(SproutEntities.BOUNCE_BUG_ENTITY, BounceBugEntityRenderer::new);
        SproutClient.registerBlockEntityRenderer(SproutBlocks.BOUNCE_BUG_JAR_BLOCK_ENTITY, ctx -> new BounceBugBottleBlockEntityRenderer());
        SproutClient.registerBlockEntityRenderer(SproutBlocks.FLOWER_BOX_ENTITY, ctx -> new FlowerBoxBlockEntityRenderer());
    }

    public static void initBlockColors() {
        SproutClient.registerBlockColor((state, world, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return -1;
            }
            if (world == null || pos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            return BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
        }, SproutBlocks.CATTIAL.get(), SproutBlocks.WATER_LENTIL.get(), SproutBlocks.SPROUTS.get());
    }

    public static void initItemColors() {
        SproutClient.registerItemColor((stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0), SproutItems.WATER_LENTIL.get(), SproutItems.SPROUTS.get());
    }

    public static void initParticleFactories() {
        SproutClient.registerParticleFactory(SproutParticles.SNOOZE, SnoozeParticle.Factory::new);
        SproutClient.registerParticleFactory(SproutParticles.SHOOTS, ShootParticle.Factory::new);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColor(BlockColor provider, Block ... items) {
        void var1_1;
        SproutClientImpl.registerBlockColor(provider, (Block[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemColor(ItemColor provider, Item ... items) {
        void var1_1;
        SproutClientImpl.registerItemColor(provider, (Item[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBlockRenderers(Supplier<Block> blockSupplier, RenderType renderLayer) {
        void var1_1;
        SproutClientImpl.renderBlockRenderers(blockSupplier, (RenderType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityTypeSupplier, EntityRendererProvider<T> renderer) {
        void var1_1;
        SproutClientImpl.registerEntityRenderer(entityTypeSupplier, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> blockEntity, BlockEntityRendererProvider<T> blockEntityRenderer) {
        void var1_1;
        SproutClientImpl.registerBlockEntityRenderer(blockEntity, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemProperty(Supplier<Item> itemSupplier, ResourceLocation name, ClampedItemPropertyFunction provider) {
        void var2_2;
        void var1_1;
        SproutClientImpl.registerItemProperty(itemSupplier, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerParticleFactory(Supplier<SimpleParticleType> particle, SpriteAwareFactory<SimpleParticleType> factory) {
        void var1_1;
        SproutClientImpl.registerParticleFactory(particle, (SpriteAwareFactory<SimpleParticleType>)var1_1);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface SpriteAwareFactory<T extends ParticleOptions> {
        @NotNull
        public ParticleProvider<T> create(SpriteSet var1);
    }
}

