/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.client.entity;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;

public class ElephantEntityModel
extends AnimatedGeoModel<ElephantEntity> {
    private static final ResourceLocation NORMAL = new ResourceLocation("sprout", "textures/entity/elephant.png");
    private static final ResourceLocation NORMAL_SLEEPING = new ResourceLocation("sprout", "textures/entity/sleeping_elephant.png");
    private static final ResourceLocation LUMPY = new ResourceLocation("sprout", "textures/entity/lumpy.png");
    private static final ResourceLocation LUMPY_SLEEPING = new ResourceLocation("sprout", "textures/entity/sleeping_lumpy.png");
    private static final ResourceLocation TREE_TRUNKS = new ResourceLocation("sprout", "textures/entity/tree_trunks.png");
    private static final ResourceLocation TREE_TRUNKS_SLEEPING = new ResourceLocation("sprout", "textures/entity/sleeping_tree_trunks.png");

    public ResourceLocation getModelResource(ElephantEntity object) {
        return new ResourceLocation("sprout", "geo/elephant.geo.json");
    }

    public ResourceLocation getTextureResource(ElephantEntity object) {
        boolean closedEyes = object.m_21825_() || object.isWatering();
        return switch (object.m_7755_().getString().toLowerCase()) {
            case "lumpy" -> {
                if (closedEyes) {
                    yield LUMPY_SLEEPING;
                }
                yield LUMPY;
            }
            case "tree_trunks" -> {
                if (closedEyes) {
                    yield TREE_TRUNKS_SLEEPING;
                }
                yield TREE_TRUNKS;
            }
            default -> closedEyes ? NORMAL_SLEEPING : NORMAL;
        };
    }

    public ResourceLocation getAnimationResource(ElephantEntity animatable) {
        return new ResourceLocation("sprout", "animations/elephant.animation.json");
    }
}

