/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.sprout.common.blocks.FlowerBoxBlockEntity;
import tech.thatgravyboat.sprout.common.flowers.FlowerBreed;
import tech.thatgravyboat.sprout.common.flowers.FlowerBreedTree;

public class FlowerBoxBlock
extends BaseEntityBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");

    public FlowerBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Level level = context.m_43725_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos nextPos = context.m_8083_().m_121945_(direction);
            BlockState nextState = level.m_8055_(nextPos);
            if (!nextState.m_60713_((Block)this)) continue;
            Direction.Axis axis = FlowerBoxBlock.getAxis(nextState);
            if (direction.m_122434_() != axis && axis != null) continue;
            BlockState state = this.m_49966_();
            switch (direction) {
                case SOUTH: {
                    state = (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case NORTH: {
                    state = (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case EAST: {
                    state = (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case WEST: {
                    state = (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
            return state;
        }
        return super.m_5573_(context);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos pos2, boolean bl) {
        super.m_6861_(state, level, pos, block, pos2, bl);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!pos2.equals((Object)pos.m_121945_(direction))) continue;
            Direction.Axis axis = FlowerBoxBlock.getAxis(state);
            if (direction.m_122434_() != axis && axis != null) {
                return;
            }
            boolean connected = level.m_8055_(pos2).m_60734_() instanceof FlowerBoxBlock;
            switch (direction) {
                case NORTH: {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(connected)));
                    break;
                }
                case SOUTH: {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(connected)));
                    break;
                }
                case EAST: {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(connected)));
                    break;
                }
                case WEST: {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(connected)));
                }
            }
            return;
        }
    }

    public static Direction.Axis getAxis(BlockState state) {
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() || ((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            return Direction.Axis.Z;
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() || ((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            return Direction.Axis.X;
        }
        return null;
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack item = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlowerBoxBlockEntity) {
            BlockItem block;
            Item item2;
            FlowerBoxBlockEntity flowerBox = (FlowerBoxBlockEntity)blockEntity;
            if (flowerBox.getFlower() == null && (item2 = item.m_41720_()) instanceof BlockItem && (block = (BlockItem)item2).m_40614_().m_204297_().m_203656_(BlockTags.f_13037_)) {
                flowerBox.setFlower(block.m_40614_());
                if (!player.m_150110_().f_35937_) {
                    item.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (flowerBox.getFlower() != null) {
                ItemStack stack = new ItemStack((ItemLike)flowerBox.getFlower());
                flowerBox.setFlower(null);
                if (item.m_41619_()) {
                    player.m_21008_(hand, stack);
                } else if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, false);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return (Boolean)state.m_61143_((Property)NORTH) != false && (Boolean)state.m_61143_((Property)SOUTH) != false || (Boolean)state.m_61143_((Property)EAST) != false && (Boolean)state.m_61143_((Property)WEST) != false;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.m_214148_(level, random, pos, state);
    }

    private static void setRandomFlower(BlockPos pos, ServerLevel level, Direction left, Direction right) {
        Block flower1 = FlowerBoxBlockEntity.getFlower(level.m_7702_(pos.m_121945_(left)));
        Block flower2 = FlowerBoxBlockEntity.getFlower(level.m_7702_(pos.m_121945_(right)));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlowerBoxBlockEntity) {
            FlowerBreed breed;
            FlowerBoxBlockEntity flowerBox = (FlowerBoxBlockEntity)blockEntity;
            if (flower1 != null && flower2 != null && FlowerBreedTree.BREEDS.containsKey(breed = FlowerBreed.of(flower1, flower2))) {
                flowerBox.setFlower(FlowerBreedTree.BREEDS.get(breed).next());
            }
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean bl) {
        if (!state.m_60713_(newState.m_60734_())) {
            FlowerBoxBlockEntity flowerBox;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FlowerBoxBlockEntity && (flowerBox = (FlowerBoxBlockEntity)blockEntity).getFlower() != null) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)flowerBox.getFlower()));
            }
            super.m_6810_(state, level, pos, newState, bl);
        }
    }

    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FlowerBoxBlockEntity(pos, state);
    }

    public boolean m_7370_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, boolean bl) {
        FlowerBoxBlockEntity flowerBox;
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof FlowerBoxBlockEntity && (flowerBox = (FlowerBoxBlockEntity)blockEntity).getFlower() == null;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        FlowerBoxBlockEntity flowerBox;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlowerBoxBlockEntity && (flowerBox = (FlowerBoxBlockEntity)blockEntity).getFlower() == null) {
            return random.m_188503_(5) == 0;
        }
        return false;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (FlowerBoxBlockEntity.getFlower(level.m_7702_(pos)) != null) {
            return;
        }
        Direction.Axis axis = FlowerBoxBlock.getAxis(state);
        if (axis == null) {
            return;
        }
        switch (axis) {
            case X: {
                FlowerBoxBlock.setRandomFlower(pos, level, Direction.WEST, Direction.EAST);
                break;
            }
            case Z: {
                FlowerBoxBlock.setRandomFlower(pos, level, Direction.SOUTH, Direction.NORTH);
            }
        }
    }
}

