/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.sprout.common.registry.SproutBlocks;

public class ShelfFungiBlock
extends BushBlock {
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)15.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0);
    public static DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ShelfFungiBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            Direction direction2;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60804_((BlockGetter)level, pos);
    }

    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public ItemStack m_7397_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.m_7374_() == SproutBlocks.RED_SHELF_FUNGI.get()) {
            return new ItemStack((ItemLike)Items.f_41953_);
        }
        if (this.m_7374_() == SproutBlocks.BROWN_SHELF_FUNGI.get()) {
            return new ItemStack((ItemLike)Items.f_41952_);
        }
        return ItemStack.f_41583_;
    }
}

