/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.config;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import tech.thatgravyboat.sprout.common.config.AnnotationData;
import tech.thatgravyboat.sprout.common.config.BuiltCategory;
import tech.thatgravyboat.sprout.common.config.BuiltConfig;
import tech.thatgravyboat.sprout.common.config.PropertyData;
import tech.thatgravyboat.sprout.common.config.PropertyType;
import tech.thatgravyboat.sprout.common.config.annotations.Category;
import tech.thatgravyboat.sprout.common.config.annotations.Config;
import tech.thatgravyboat.sprout.common.config.annotations.Property;
import tech.thatgravyboat.sprout.common.config.forge.ConfigLoaderImpl;

public class ConfigLoader {
    public static void registerConfig(Object object) {
        BuiltCategory category;
        try {
            category = ConfigLoader.buildCategory(null, object);
        }
        catch (Exception e) {
            e.printStackTrace();
            category = null;
        }
        if (!(category instanceof BuiltConfig)) {
            throw new IllegalArgumentException("Config supplied does not have a @Config annotation");
        }
        BuiltConfig config = (BuiltConfig)category;
        ConfigLoader.registerConfig(config);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerConfig(BuiltConfig config) {
        ConfigLoaderImpl.registerConfig(config);
    }

    public static BuiltCategory buildCategory(String categoryDesc, Object object) throws IllegalAccessException {
        BuiltCategory category;
        Class<?> configClass = object.getClass();
        if (configClass.isAnnotationPresent(Config.class)) {
            category = new BuiltConfig(configClass.getAnnotation(Config.class).value());
        } else if (configClass.isAnnotationPresent(Category.class)) {
            category = new BuiltCategory(categoryDesc, configClass.getAnnotation(Category.class).value());
        } else {
            throw new IllegalStateException("Config does not contain any @Config annotation or @Category");
        }
        for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class) || !field.canAccess(object)) continue;
            PropertyType type = field.getAnnotation(Property.class).type();
            if (type.equals((Object)PropertyType.CATEGORY)) {
                category.categories.add(ConfigLoader.buildCategory(field.getAnnotation(Property.class).description(), field.get(object)));
                continue;
            }
            category.properties.add(new PropertyData(object, field, AnnotationData.getData(field)));
        }
        return category;
    }
}

