/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.config.forge;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.thatgravyboat.sprout.common.config.AnnotationData;
import tech.thatgravyboat.sprout.common.config.BuiltCategory;
import tech.thatgravyboat.sprout.common.config.BuiltConfig;
import tech.thatgravyboat.sprout.common.config.PropertyData;

public class ConfigLoaderImpl {
    public static final Map<ForgeConfigSpec, BuiltConfig> CONFIGS = new HashMap<ForgeConfigSpec, BuiltConfig>();

    public static void initialize() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ConfigLoaderImpl::onConfigLoad);
        bus.addListener(ConfigLoaderImpl::onConfigReload);
        CONFIGS.forEach((spec, config) -> ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, config.fileName + ".toml"));
    }

    public static void onConfigLoad(ModConfigEvent.Loading loading) {
        ConfigLoaderImpl.loadConfig((IConfigSpec<ForgeConfigSpec>)loading.getConfig().getSpec());
    }

    public static void onConfigReload(ModConfigEvent.Reloading loading) {
        ConfigLoaderImpl.loadConfig((IConfigSpec<ForgeConfigSpec>)loading.getConfig().getSpec());
    }

    private static void loadConfig(IConfigSpec<ForgeConfigSpec> spec) {
        BuiltConfig builtConfig = CONFIGS.get(spec.self());
        if (builtConfig == null) {
            return;
        }
        ConfigLoaderImpl.loadConfig(builtConfig, ((ForgeConfigSpec)spec.self()).getValues());
    }

    private static void loadConfig(BuiltCategory category, UnmodifiableConfig config) {
        config.valueMap().forEach((id, value) -> {
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                category.getProperty((String)id).ifPresent(data -> {
                    if (configValue instanceof ForgeConfigSpec.BooleanValue) {
                        ForgeConfigSpec.BooleanValue booleanValue = (ForgeConfigSpec.BooleanValue)configValue;
                        data.setBoolean((Boolean)booleanValue.get());
                    }
                    if (configValue instanceof ForgeConfigSpec.IntValue) {
                        ForgeConfigSpec.IntValue intValue = (ForgeConfigSpec.IntValue)configValue;
                        data.setInt((Integer)intValue.get());
                    }
                    if (configValue instanceof ForgeConfigSpec.DoubleValue) {
                        ForgeConfigSpec.DoubleValue doubleValue = (ForgeConfigSpec.DoubleValue)configValue;
                        data.setDouble((Double)doubleValue.get());
                    }
                });
            } else if (value instanceof AbstractConfig) {
                AbstractConfig subConfig = (AbstractConfig)value;
                category.getCategory((String)id).ifPresent(cat -> ConfigLoaderImpl.loadConfig(cat, (UnmodifiableConfig)subConfig));
            }
        });
    }

    public static void registerConfig(BuiltConfig config) {
        try {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            for (PropertyData property : config.properties) {
                ConfigLoaderImpl.buildProperty(builder, property);
            }
            for (BuiltCategory category : config.categories) {
                ConfigLoaderImpl.buildCategory(builder, category);
            }
            CONFIGS.put(builder.build(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCategory(ForgeConfigSpec.Builder builder, BuiltCategory category) throws IllegalAccessException {
        builder.push(category.category);
        if (category.categoryDesc != null) {
            builder.comment(category.categoryDesc);
        }
        for (PropertyData property : category.properties) {
            ConfigLoaderImpl.buildProperty(builder, property);
        }
        for (BuiltCategory builtCategory : category.categories) {
            ConfigLoaderImpl.buildCategory(builder, builtCategory);
        }
        builder.pop();
    }

    private static void buildProperty(ForgeConfigSpec.Builder builder, PropertyData data) throws IllegalAccessException {
        AnnotationData annotationData = data.data();
        builder.comment(annotationData.description());
        switch (annotationData.type()) {
            case BOOLEAN: {
                builder.define(data.getId(), data.getBoolean());
                break;
            }
            case INT: {
                builder.defineInRange(data.getId(), data.getInt(), annotationData.min(), annotationData.max());
                break;
            }
            case DOUBLE: {
                builder.defineInRange(data.getId(), data.getDouble(), annotationData.minD(), annotationData.maxD());
                break;
            }
            default: {
                throw new IllegalAccessException("Unknown property type.");
            }
        }
    }
}

