/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.sprout.common.entities.Herbivore;
import tech.thatgravyboat.sprout.common.entities.goals.DrinkWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.FindPlantGoal;
import tech.thatgravyboat.sprout.common.entities.goals.FindWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SprayWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SproutWanderGoal;
import tech.thatgravyboat.sprout.common.registry.SproutItems;
import tech.thatgravyboat.sprout.common.registry.SproutParticles;
import tech.thatgravyboat.sprout.common.registry.SproutSounds;

public class ElephantEntity
extends TamableAnimal
implements IAnimatable,
Herbivore {
    protected static final EntityDataAccessor<Boolean> DRINKING = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> WATERING = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> HAS_WATER = SynchedEntityData.m_135353_(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient PEANUT_TEMPT_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)SproutItems.PEANUT.get()});
    public static final TagKey<Item> PEANUT_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("sprout", "peanuts"));
    @Nullable
    private BlockPos waterPos;
    private BlockPos plantPos;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ElephantEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canSpawn(EntityType<ElephantEntity> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() > world.m_5736_() && world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) && world.m_213780_().m_188503_(10) == 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DRINKING, (Object)false);
        this.m_20088_().m_135372_(WATERING, (Object)false);
        this.m_20088_().m_135372_(HAS_WATER, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_20088_().m_135381_(DRINKING, (Object)nbt.m_128471_("Drinking"));
        this.m_20088_().m_135381_(WATERING, (Object)nbt.m_128471_("Watering"));
        this.m_20088_().m_135381_(HAS_WATER, (Object)nbt.m_128471_("HasWater"));
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Drinking", ((Boolean)this.m_20088_().m_135370_(DRINKING)).booleanValue());
        nbt.m_128379_("Watering", ((Boolean)this.m_20088_().m_135370_(WATERING)).booleanValue());
        nbt.m_128379_("HasWater", ((Boolean)this.m_20088_().m_135370_(HAS_WATER)).booleanValue());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 0.5, PEANUT_TEMPT_ITEM, false));
        this.f_21345_.m_25352_(3, (Goal)new FindWaterGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DrinkWaterGoal(this, 3));
        this.f_21345_.m_25352_(3, new FindPlantGoal<ElephantEntity>(this, block -> block instanceof CropBlock));
        this.f_21345_.m_25352_(3, (Goal)new SprayWaterGoal(this, 6));
        this.f_21345_.m_25352_(8, new SproutWanderGoal<ElephantEntity>(this, 0.2));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public ElephantEntity getBreedOffspring(@NotNull ServerLevel world, @NotNull AgeableMob entity) {
        return null;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_21839_(false);
        this.setWatering(false);
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(PEANUT_TAG)) {
            if (!this.m_21824_()) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!this.f_19853_.m_5776_()) {
                    if (this.f_19796_.m_188503_(10) == 0) {
                        this.m_21828_(player);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!this.f_19853_.m_5776_()) {
                    this.m_5634_(2.0f);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
            return InteractionResult.PASS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!this.f_19853_.m_5776_()) {
                if (!this.m_21827_()) {
                    this.setWatering(false);
                }
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public boolean isDrinking() {
        return (Boolean)this.m_20088_().m_135370_(DRINKING);
    }

    public boolean isWatering() {
        return (Boolean)this.m_20088_().m_135370_(WATERING);
    }

    public boolean hasWater() {
        return (Boolean)this.m_20088_().m_135370_(HAS_WATER);
    }

    @Nullable
    public BlockPos getWaterPos() {
        return this.waterPos;
    }

    public void setWaterPos(@Nullable BlockPos waterPos) {
        this.waterPos = waterPos;
    }

    public boolean isNearWater() {
        return this.isNearBlock(this.getWaterPos(), 1);
    }

    public boolean isNearBlock(BlockPos pos, int range) {
        return pos != null && pos.m_123331_((Vec3i)this.m_20183_()) < (double)(range * range);
    }

    public boolean isNearPlant() {
        return this.isNearBlock(this.getTargetPlant(), 3);
    }

    public void setDrinking(boolean bool) {
        this.m_20088_().m_135381_(DRINKING, (Object)bool);
    }

    public void setWatering(boolean bool) {
        this.m_20088_().m_135381_(WATERING, (Object)bool);
    }

    public void setIfHasWater(boolean bool) {
        this.m_20088_().m_135381_(HAS_WATER, (Object)bool);
    }

    private <E extends IAnimatable> PlayState actions(AnimationEvent<E> event) {
        if (!event.isMoving() && !this.m_21825_()) {
            if (this.isDrinking()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.elephant.drinking", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.isWatering()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.elephant.watering", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState walkCycle(AnimationEvent<E> event) {
        if (!this.m_21825_()) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.elephant.walking", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.elephant.idling", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState sitStand(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.elephant.sleeping", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> void particleInitializer(ParticleKeyFrameEvent<E> event) {
        if ("sprout:snooze".equals(event.effect)) {
            this.f_19853_.m_7106_((ParticleOptions)SproutParticles.SNOOZE.get(), this.m_20185_(), this.m_20186_() + 0.8, this.m_20189_(), 0.01, 1.0, 0.01);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private <E extends IAnimatable> void soundInitializer(SoundKeyframeEvent<E> event) {
        if (!this.f_19853_.m_5776_()) {
            return;
        }
        if ("sprout:sleep".equals(event.sound)) {
            this.f_19853_.m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)this, SproutSounds.SLEEP.get(), SoundSource.AMBIENT, 0.5f, 0.5f);
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "action_controller", 5.0f, this::actions));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walk_controller", 5.0f, this::walkCycle));
        AnimationController sleepController = new AnimationController((IAnimatable)this, "sit_controller", 2.0f, this::sitStand);
        sleepController.registerParticleListener(this::particleInitializer);
        sleepController.registerSoundListener(this::soundInitializer);
        animationData.addAnimationController(sleepController);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isNotBusy() {
        return !this.isDrinking() && !this.m_21827_() && !this.isWatering();
    }

    @Override
    public boolean specialPredicate() {
        return this.hasWater();
    }

    @Override
    public void setTargetPlant(BlockPos pos) {
        this.plantPos = pos;
    }

    @Override
    @Nullable
    public BlockPos getTargetPlant() {
        return this.plantPos;
    }
}

