/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;
import tech.thatgravyboat.sprout.common.utils.EntityPathingUtils;

public class FindWaterGoal
extends Goal {
    private static final List<BlockPos> POSITIONAL_OFFSETS = EntityPathingUtils.getPositionalOffsets(12);
    private final ElephantEntity elephant;
    @Nullable
    private BlockPos targetPosition;

    public FindWaterGoal(ElephantEntity elephant) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        this.elephant = elephant;
    }

    public boolean m_8036_() {
        if (this.elephant.m_21826_() != null && !this.elephant.hasWater()) {
            this.findWaterSource();
            return this.targetPosition != null && this.elephant.isNotBusy() && this.targetPosition.m_123331_((Vec3i)this.elephant.m_20183_()) > 1.0;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.targetPosition != null && this.targetPosition.m_123331_((Vec3i)this.elephant.m_20183_()) > 1.0;
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.targetPosition != null) {
            PathNavigation nav = this.elephant.m_21573_();
            nav.m_26519_((double)this.targetPosition.m_123341_() + 0.5, (double)this.targetPosition.m_123342_() + 0.75, (double)this.targetPosition.m_123343_() + 0.5, 0.3);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.elephant.setWaterPos(this.targetPosition);
        this.targetPosition = null;
    }

    public void findWaterSource() {
        if (this.targetPosition != null) {
            return;
        }
        BlockPos.MutableBlockPos waterPos = this.elephant.m_20183_().m_122032_();
        for (BlockPos blockPos : POSITIONAL_OFFSETS) {
            waterPos.m_175306_((Vec3i)this.elephant.m_20183_(), (Vec3i)blockPos);
            if (!this.elephant.f_19853_.m_46801_((BlockPos)waterPos)) continue;
            Path path = this.elephant.m_21573_().m_7864_((BlockPos)waterPos, 1);
            this.targetPosition = path == null ? null : path.m_77406_();
            return;
        }
    }
}

