/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;

public class SprayWaterGoal
extends Goal {
    private int sprayTimer;
    private final int timerCap;
    private BlockPos plantPos;
    private final ElephantEntity elephant;

    public SprayWaterGoal(ElephantEntity elephant, int timeInSeconds) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        this.elephant = elephant;
        this.timerCap = timeInSeconds * 20;
    }

    public boolean m_8036_() {
        return this.elephant.isNearPlant() && this.elephant.hasWater() && this.elephant.isNotBusy();
    }

    public void m_8056_() {
        super.m_8056_();
        this.sprayTimer = 0;
        this.plantPos = this.elephant.getTargetPlant();
        this.elephant.m_7618_(this.elephant.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.elephant.getTargetPlant()));
        this.elephant.setWatering(true);
    }

    public boolean m_8045_() {
        return this.elephant.isNearPlant() && this.sprayTimer++ <= this.timerCap;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.sprayTimer < 10) {
            return;
        }
        this.elephant.m_7618_(this.elephant.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.elephant.getTargetPlant()));
        AABB blockBox = new AABB(this.plantPos.m_121945_(this.elephant.m_6350_())).m_82377_(1.0, 1.0, 1.0);
        ServerLevel sWorld = (ServerLevel)this.elephant.f_19853_;
        sWorld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)this.plantPos.m_123341_(), (double)this.plantPos.m_123342_(), (double)this.plantPos.m_123343_(), 10, 1.0, 1.0, 1.0, 1.4);
        BlockPos.m_121921_((AABB)blockBox).filter(blockPos -> this.elephant.f_19853_.m_8055_(blockPos).m_60734_() instanceof CropBlock).forEach(blockPos -> {
            if (this.elephant.f_19853_.m_213780_().m_188503_(150) == 1) {
                BlockState crop = this.elephant.f_19853_.m_8055_(blockPos);
                BonemealableBlock fertilizable = (BonemealableBlock)crop.m_60734_();
                fertilizable.m_214148_(sWorld, this.elephant.f_19853_.f_46441_, blockPos, crop);
            }
        });
        BlockPos.m_121921_((AABB)blockBox).filter(blockPos -> this.elephant.f_19853_.m_8055_(blockPos).m_60734_() instanceof FarmBlock).forEach(blockPos -> {
            BlockState blockState = sWorld.m_8055_(blockPos);
            int moisture = (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61423_);
            if (this.elephant.f_19853_.m_213780_().m_188503_(15) == 1 && moisture < 7) {
                this.elephant.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7)));
            }
        });
    }

    public void m_8041_() {
        super.m_8041_();
        this.elephant.setWatering(false);
        this.elephant.setTargetPlant(null);
        this.elephant.setIfHasWater(false);
    }
}

