/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import tech.thatgravyboat.sprout.common.entities.BounceBugEntity;
import tech.thatgravyboat.sprout.common.entities.BounceBugVariant;

public class SpreadShroomOrGrowWartGoal
extends Goal {
    private final BounceBugEntity bug;
    private static final int TIMER_CAP = 120;
    private boolean isShroom;
    private int growTimer;
    private BlockPos shroomPos;

    public SpreadShroomOrGrowWartGoal(BounceBugEntity bug) {
        this.bug = bug;
    }

    public boolean m_8036_() {
        if (!this.bug.m_21825_() && this.bug.isNotBusy() && this.bug.getTargetPlant() != null) {
            return this.bug.isNearShroom();
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.bug.setIfSpreadingSpores(true);
        Block block = this.bug.m_9236_().m_8055_(this.bug.getTargetPlant()).m_60734_();
        this.isShroom = block instanceof FungusBlock || block instanceof MushroomBlock;
        this.bug.m_7618_(this.bug.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.bug.getTargetPlant()));
        this.shroomPos = this.bug.getTargetPlant();
    }

    public boolean m_8045_() {
        return this.bug.isNearShroom() && this.bug.getTargetPlant() != null && this.growTimer < 120 && !this.bug.m_9236_().m_8055_(this.shroomPos).m_60795_() && !this.bug.m_21825_();
    }

    public void m_8037_() {
        Level world = this.bug.m_9236_();
        BounceBugVariant variant = this.bug.getBounceBugVariant();
        if (!world.m_5776_()) {
            ((ServerLevel)world).m_8767_(variant.particleEffect, this.bug.m_20185_(), this.bug.m_20186_(), this.bug.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
        }
        this.bug.m_7618_(this.bug.m_20203_().m_81378_(), Vec3.m_82512_((Vec3i)this.bug.getTargetPlant()));
        if (this.isShroom && this.growTimer % 15 == 1) {
            AABB blocks = AABB.m_82333_((Vec3)Vec3.m_82512_((Vec3i)this.shroomPos)).m_82377_(2.0, 1.0, 2.0);
            BlockPos.m_121921_((AABB)blocks).filter(blockPos -> world.m_8055_(blockPos).m_60795_()).filter(blockPos -> SpreadShroomOrGrowWartGoal.mushroomPredicate(world.m_8055_(this.shroomPos), world.m_8055_(blockPos.m_7495_()), world, blockPos)).forEach(blockPos -> {
                if (world.f_46441_.m_188503_(30) == 1) {
                    if (!world.m_5776_()) {
                        ((ServerLevel)world).m_8767_(variant.particleEffect, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 2, 0.1, 0.1, 0.1, 0.2);
                    }
                    world.m_46597_(blockPos, world.m_8055_(this.shroomPos).m_60734_().m_49966_());
                }
            });
        } else if (!this.isShroom) {
            AABB blocks = AABB.m_82333_((Vec3)Vec3.m_82512_((Vec3i)this.shroomPos)).m_82377_(1.0, 1.0, 1.0);
            BlockPos.m_121921_((AABB)blocks).filter(blockPos -> world.m_8055_(blockPos).m_60713_(Blocks.f_50200_)).forEach(blockPos -> {
                int age;
                BlockState state = world.m_8055_(blockPos);
                if (world.m_213780_().m_188503_(150) == 1 && (age = ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_)).intValue()) < 3) {
                    world.m_46597_(blockPos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(age + 1)));
                }
            });
        }
        ++this.growTimer;
    }

    private static boolean mushroomPredicate(BlockState shroom, BlockState below, Level world, BlockPos pos) {
        if (shroom.m_60734_() instanceof MushroomBlock) {
            return below.m_204336_(BlockTags.f_13057_) || world.m_46849_(pos, 0) < 13 && below.m_60804_((BlockGetter)world, pos);
        }
        if (shroom.m_60734_() instanceof FungusBlock) {
            return below.m_204336_(BlockTags.f_13077_) || below.m_60713_(Blocks.f_50136_) || below.m_60713_(Blocks.f_50195_) || below.m_204336_(BlockTags.f_144274_) || below.m_60713_(Blocks.f_50093_);
        }
        return false;
    }

    public void m_8041_() {
        this.growTimer = 0;
        this.bug.setIfSpreadingSpores(false);
        this.bug.setTargetPlant(null);
        super.m_8041_();
    }
}

