/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.flowers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import tech.thatgravyboat.sprout.common.flowers.FlowerBreed;
import tech.thatgravyboat.sprout.common.flowers.FlowerColor;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;
import tech.thatgravyboat.sprout.common.registry.SproutFlowers;
import tech.thatgravyboat.sprout.common.utils.RandomCollection;

public class FlowerBreedTree {
    public static final Map<FlowerBreed, RandomCollection<Block>> BREEDS = new HashMap<FlowerBreed, RandomCollection<Block>>();

    private static void addFlowers(Pair<FlowerType, FlowerColor> flower1, Pair<FlowerType, FlowerColor> flower2, double normal, double special) {
        Block block2;
        Map<FlowerType, Supplier<Block>> flower1Type = SproutFlowers.FLOWERS.get(flower1.getSecond());
        Map<FlowerType, Supplier<Block>> flower2Type = SproutFlowers.FLOWERS.get(flower2.getSecond());
        Block block1 = flower1Type.get(flower1.getFirst()).get();
        if (block1 == (block2 = flower2Type.get(flower2.getFirst()).get())) {
            FlowerBreedTree.register(new Builder(block1, block2).add(block1, 1.0));
            return;
        }
        Builder builder = new Builder(block1, block2);
        builder.add(block1, normal);
        builder.add(block2, normal);
        builder.add(flower1Type.get(flower2.getFirst()), special);
        builder.add(flower2Type.get(flower1.getFirst()), special);
        FlowerBreedTree.register(builder);
    }

    public static void register(Builder builder) {
        BREEDS.put(builder.breed, builder.flowers);
    }

    static {
        List normalFlowers = FlowerColor.stream().filter(FlowerColor::isNormal).flatMap(color -> FlowerType.stream().map(type -> Pair.of((Object)type, (Object)color))).toList();
        List specialFlowers = FlowerColor.stream().filter(FlowerColor::isSpecial).flatMap(color -> FlowerType.stream().map(type -> Pair.of((Object)type, (Object)color))).toList();
        List combinedFlowers = Stream.concat(specialFlowers.stream(), normalFlowers.stream()).toList();
        for (Pair flower1 : normalFlowers) {
            for (Pair flower2 : normalFlowers) {
                FlowerBreedTree.addFlowers((Pair<FlowerType, FlowerColor>)flower1, (Pair<FlowerType, FlowerColor>)flower2, 40.0, 10.0);
            }
        }
        for (Pair flower1 : specialFlowers) {
            for (Pair flower2 : combinedFlowers) {
                FlowerBreedTree.addFlowers((Pair<FlowerType, FlowerColor>)flower1, (Pair<FlowerType, FlowerColor>)flower2, 49.0, 1.0);
            }
        }
        for (Pair flower2 : combinedFlowers) {
            Block block2 = SproutFlowers.FLOWERS.get(flower2.getSecond()).get(flower2.getFirst()).get();
            Builder builder = new Builder(Blocks.f_50070_, block2);
            builder.add(Blocks.f_50070_, 49.95);
            builder.add(block2, 49.95);
            builder.add(SproutFlowers.FLOWERS.get((Object)FlowerColor.BLACK).get(flower2.getFirst()), 0.05);
            builder.add(SproutFlowers.FLOWERS.get((Object)FlowerColor.BROWN).get(flower2.getFirst()), 0.05);
            FlowerBreedTree.register(builder);
        }
        FlowerBreedTree.register(new Builder(Blocks.f_50070_, Blocks.f_50070_).add(Blocks.f_50070_, 1.0));
    }

    private static class Builder {
        private final FlowerBreed breed;
        private final RandomCollection<Block> flowers = new RandomCollection();

        public Builder(Block flower1, Block flower2) {
            this.breed = FlowerBreed.of(flower1, flower2);
        }

        public Builder add(Supplier<Block> flower, double weight) {
            this.flowers.add(weight, flower.get());
            return this;
        }

        public Builder add(Block flower, double weight) {
            this.flowers.add(weight, flower);
            return this;
        }
    }
}

