/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.flowers;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;

public enum FlowerColor {
    WHITE(FlowerType.TULIP, FlowerType.LILY_OF_THE_VALLEY),
    ORANGE(FlowerType.TULIP),
    MAGENTA(FlowerType.ALLIUM),
    LIGHT_BLUE(FlowerType.ORCHID),
    YELLOW(FlowerType.DANDELION),
    LIME(new FlowerType[0]),
    PINK(FlowerType.TULIP),
    GRAY(new FlowerType[0]),
    LIGHT_GRAY(FlowerType.AZURE_BLUET, FlowerType.DAISY),
    CYAN(new FlowerType[0]),
    PURPLE(new FlowerType[0]),
    BLUE(FlowerType.CORNFLOWER),
    BROWN(true, new FlowerType[0]),
    GREEN(new FlowerType[0]),
    RED(FlowerType.POPPY, FlowerType.TULIP),
    BLACK(true, new FlowerType[0]);

    public final boolean special;
    public final Set<FlowerType> bannedTypes;

    private FlowerColor(FlowerType ... bannedTypes) {
        this(false, bannedTypes);
    }

    private FlowerColor(boolean special, FlowerType ... bannedTypes) {
        this.special = special;
        this.bannedTypes = Set.of(bannedTypes);
    }

    public boolean isNormal() {
        return !this.isSpecial();
    }

    public boolean isSpecial() {
        return this.special;
    }

    public static Stream<FlowerColor> stream() {
        return Arrays.stream(FlowerColor.values());
    }
}

