/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.sprout.common.blocks.BasicGrassBlock;
import tech.thatgravyboat.sprout.common.blocks.BounceBugBottle;
import tech.thatgravyboat.sprout.common.blocks.BounceBugBottleBlockEntity;
import tech.thatgravyboat.sprout.common.blocks.DuneGrass;
import tech.thatgravyboat.sprout.common.blocks.FlowerBoxBlock;
import tech.thatgravyboat.sprout.common.blocks.FlowerBoxBlockEntity;
import tech.thatgravyboat.sprout.common.blocks.PeanutCrop;
import tech.thatgravyboat.sprout.common.blocks.ShelfFungiBlock;
import tech.thatgravyboat.sprout.common.blocks.TallDeadBushBlock;
import tech.thatgravyboat.sprout.common.registry.SproutFlowers;
import tech.thatgravyboat.sprout.common.registry.forge.SproutBlocksImpl;

public class SproutBlocks {
    public static final Supplier<Block> PEANUT_PLANT_BLOCK = SproutBlocks.registerBlock("peanut_plant", () -> new PeanutCrop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50249_)));
    public static final Supplier<Block> CATTIAL = SproutBlocks.registerBlock("cattail", () -> new DoublePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_)));
    public static final Supplier<Block> DUNE_GRASS = SproutBlocks.registerBlock("dune_grass", () -> new DuneGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)){});
    public static final Supplier<Block> SPROUTS = SproutBlocks.registerBlock("sprouts", () -> new BasicGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_)){});
    public static final Supplier<Block> TALL_DEAD_BUSH = SproutBlocks.registerBlock("tall_dead_bush", () -> new TallDeadBushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50036_)));
    public static final Supplier<Block> WATER_LENTIL = SproutBlocks.registerBlock("water_lentil", () -> new WaterlilyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50196_).m_60910_()){});
    public static final Supplier<Block> BOUNCE_BUG_BOTTLE = SproutBlocks.registerBlock("bounce_bug_jar", () -> new BounceBugBottle(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60953_(value -> 3).m_60960_((state, world, pos) -> false)));
    public static final Supplier<Block> BROWN_SHELF_FUNGI = SproutBlocks.registerBlock("brown_shelf_fungi", () -> new ShelfFungiBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50180_).m_60966_().m_60910_().m_60955_()));
    public static final Supplier<Block> RED_SHELF_FUNGI = SproutBlocks.registerBlock("red_shelf_fungi", () -> new ShelfFungiBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50181_).m_60966_().m_60910_().m_60955_()));
    public static final Supplier<Block> FLOWER_BOX = SproutBlocks.registerBlock("flower_box", () -> new FlowerBoxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)));
    public static Supplier<BlockEntityType<BounceBugBottleBlockEntity>> BOUNCE_BUG_JAR_BLOCK_ENTITY = SproutBlocks.registerBlockEntity("bounce_bug_block_entity", () -> SproutBlocks.createBlockEntityType(BounceBugBottleBlockEntity::new, BOUNCE_BUG_BOTTLE.get()));
    public static Supplier<BlockEntityType<FlowerBoxBlockEntity>> FLOWER_BOX_ENTITY = SproutBlocks.registerBlockEntity("flower_box", () -> SproutBlocks.createBlockEntityType(FlowerBoxBlockEntity::new, FLOWER_BOX.get()));

    public static void registerBlocks() {
        SproutFlowers.registerBlocks();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Supplier<Block> registerBlock(String name, Supplier<Block> blockSupplier) {
        void var1_1;
        return SproutBlocksImpl.registerBlock(name, (Supplier<Block>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> item) {
        void var1_1;
        return SproutBlocksImpl.registerBlockEntity(id, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityFactory<T> factory, Block ... block) {
        void var1_1;
        return SproutBlocksImpl.createBlockEntityType(factory, (Block[])var1_1);
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity> {
        @NotNull
        public T create(BlockPos var1, BlockState var2);
    }
}

