/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import tech.thatgravyboat.sprout.common.entities.BounceBugEntity;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;
import tech.thatgravyboat.sprout.common.registry.SpawnData;
import tech.thatgravyboat.sprout.common.registry.forge.SproutEntitiesImpl;

public class SproutEntities {
    public static final Supplier<EntityType<ElephantEntity>> ELEPHANT_ENTITY_TYPE = SproutEntities.registerEntity("elephant", ElephantEntity::new, MobCategory.AMBIENT, 0.9f, 0.9f);
    public static final Supplier<EntityType<BounceBugEntity>> BOUNCE_BUG_ENTITY = SproutEntities.registerEntity("bounce_bug", BounceBugEntity::new, MobCategory.AMBIENT, 0.5f, 0.5f);

    public static void addSpawnRules() {
        SproutEntities.setSpawnRules(ELEPHANT_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ElephantEntity::canSpawn);
        SproutEntities.setSpawnRules(BOUNCE_BUG_ENTITY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BounceBugEntity::canSpawn);
    }

    public static void addSpawns() {
        SproutEntities.addEntityToBiome((ResourceKey<Biome>)Biomes.f_48200_, new SpawnData(BOUNCE_BUG_ENTITY.get(), MobCategory.AMBIENT, 25, 1, 4));
        SproutEntities.addEntityToBiome((ResourceKey<Biome>)Biomes.f_48201_, new SpawnData(BOUNCE_BUG_ENTITY.get(), MobCategory.AMBIENT, 25, 1, 4));
        SproutEntities.addEntityToBiome((ResourceKey<Biome>)Biomes.f_186754_, new SpawnData(ELEPHANT_ENTITY_TYPE.get(), MobCategory.AMBIENT, 1, 0, 1));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> Supplier<EntityType<T>> registerEntity(String name, EntityType.EntityFactory<T> factory, MobCategory group, float width, float height) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return SproutEntitiesImpl.registerEntity(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addEntityToBiome(ResourceKey<Biome> biome, SpawnData data) {
        void var1_1;
        SproutEntitiesImpl.addEntityToBiome(biome, (SpawnData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Mob> void setSpawnRules(EntityType<T> entityType, SpawnPlacements.Type location, Heightmap.Types type, SpawnPlacements.SpawnPredicate<T> predicate) {
        void var3_3;
        void var2_2;
        void var1_1;
        SproutEntitiesImpl.setSpawnRules(entityType, (SpawnPlacements.Type)var1_1, (Heightmap.Types)var2_2, var3_3);
    }

    public static void registerEntities() {
    }
}

