/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import tech.thatgravyboat.sprout.common.flowers.FlowerColor;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;
import tech.thatgravyboat.sprout.common.registry.SproutBlocks;
import tech.thatgravyboat.sprout.common.registry.SproutItems;
import tech.thatgravyboat.sprout.common.registry.forge.SproutFlowersImpl;

public class SproutFlowers {
    public static final Map<FlowerColor, Map<FlowerType, Supplier<Block>>> FLOWERS = (Map)Util.m_137469_(new HashMap(), map -> {
        map.compute(FlowerColor.WHITE, SproutFlowers.make(flowers -> flowers.put(FlowerType.TULIP, () -> Blocks.f_50118_)));
        map.compute(FlowerColor.WHITE, SproutFlowers.make(flowers -> flowers.put(FlowerType.LILY_OF_THE_VALLEY, () -> Blocks.f_50071_)));
        map.compute(FlowerColor.ORANGE, SproutFlowers.make(flowers -> flowers.put(FlowerType.TULIP, () -> Blocks.f_50117_)));
        map.compute(FlowerColor.MAGENTA, SproutFlowers.make(flowers -> flowers.put(FlowerType.ALLIUM, () -> Blocks.f_50114_)));
        map.compute(FlowerColor.LIGHT_BLUE, SproutFlowers.make(flowers -> flowers.put(FlowerType.ORCHID, () -> Blocks.f_50113_)));
        map.compute(FlowerColor.YELLOW, SproutFlowers.make(flowers -> flowers.put(FlowerType.DANDELION, () -> Blocks.f_50111_)));
        map.compute(FlowerColor.PINK, SproutFlowers.make(flowers -> flowers.put(FlowerType.TULIP, () -> Blocks.f_50119_)));
        map.compute(FlowerColor.LIGHT_GRAY, SproutFlowers.make(flowers -> flowers.put(FlowerType.AZURE_BLUET, () -> Blocks.f_50115_)));
        map.compute(FlowerColor.LIGHT_GRAY, SproutFlowers.make(flowers -> flowers.put(FlowerType.DAISY, () -> Blocks.f_50120_)));
        map.compute(FlowerColor.BLUE, SproutFlowers.make(flowers -> flowers.put(FlowerType.CORNFLOWER, () -> Blocks.f_50121_)));
        map.compute(FlowerColor.RED, SproutFlowers.make(flowers -> flowers.put(FlowerType.POPPY, () -> Blocks.f_50112_)));
        map.compute(FlowerColor.RED, SproutFlowers.make(flowers -> flowers.put(FlowerType.TULIP, () -> Blocks.f_50116_)));
    });
    public static final List<Supplier<Block>> POTTED_FLOWERS = new ArrayList<Supplier<Block>>();

    public static void registerBlocks() {
        for (FlowerColor color : FlowerColor.values()) {
            for (FlowerType type : FlowerType.values()) {
                if (color.bannedTypes.contains((Object)type)) continue;
                String id = color.name().toLowerCase(Locale.ROOT) + "_" + type.name().toLowerCase(Locale.ROOT);
                Supplier<Block> block = SproutBlocks.registerBlock(id, () -> new FlowerBlock(MobEffects.f_19617_, 4, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_)));
                FLOWERS.compute(color, SproutFlowers.make(flowers -> flowers.put(type, block)));
                POTTED_FLOWERS.add(SproutFlowers.registerFlowerPot("potted_" + id, block));
            }
        }
    }

    public static void registerItems() {
        for (Map.Entry<FlowerColor, Map<FlowerType, Supplier<Block>>> color : FLOWERS.entrySet()) {
            FlowerColor flowerColor = color.getKey();
            for (Map.Entry<FlowerType, Supplier<Block>> flowers : color.getValue().entrySet()) {
                if (flowerColor.bannedTypes.contains((Object)flowers.getKey())) continue;
                String id = flowerColor.name().toLowerCase(Locale.ROOT) + "_" + flowers.getKey().name().toLowerCase(Locale.ROOT);
                SproutItems.registerItem(id, () -> new BlockItem((Block)((Supplier)flowers.getValue()).get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
            }
        }
    }

    private static <A, K, V> BiFunction<? super A, Map<K, V>, Map<K, V>> make(Consumer<Map<K, V>> map) {
        return (k, v) -> {
            if (v != null) {
                map.accept((Map)v);
                return v;
            }
            HashMap newMap = new HashMap();
            map.accept(newMap);
            return newMap;
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Supplier<Block> registerFlowerPot(String id, Supplier<Block> block) {
        void var1_1;
        return SproutFlowersImpl.registerFlowerPot(id, (Supplier<Block>)var1_1);
    }
}

