/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.forge;

import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import tech.thatgravyboat.sprout.SproutClient;
import tech.thatgravyboat.sprout.forge.SproutClientImpl;

@Mod.EventBusSubscriber(modid="sprout", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SproutForgeClient {
    public static void clientSetup(FMLClientSetupEvent event) {
        SproutClient.init();
    }

    @SubscribeEvent
    public static void particleFactoryRegistry(RegisterParticleProvidersEvent event) {
        SproutClient.initParticleFactories();
        SproutClientImpl.PARTICLES.forEach((particle, factory) -> event.register((ParticleType)particle.get(), factory::create));
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        SproutClient.initItemColors();
        SproutClientImpl.ITEM_COLOR_PROVIDERS.forEach(colors -> event.register((ItemColor)colors.getFirst(), (ItemLike[])colors.getSecond()));
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        SproutClient.initBlockColors();
        SproutClientImpl.BLOCK_COLOR_PROVIDERS.forEach(colors -> event.register((BlockColor)colors.getFirst(), (Block[])colors.getSecond()));
    }
}

