/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomItemGroup
extends ItemGroup {
    private final ItemSorter itemSorter;
    Supplier<IItemProvider> iconItem;

    public CustomItemGroup(String label, Supplier<IItemProvider> iconItem) {
        super(label);
        this.iconItem = iconItem;
        this.itemSorter = new ItemSorter();
    }

    public ItemStack func_78016_d() {
        if (this.iconItem != null) {
            return new ItemStack(this.iconItem.get());
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_78018_a(NonNullList<ItemStack> items) {
        super.func_78018_a(items);
        Collections.sort(items, this.itemSorter);
    }

    public void addToSortingList(List<IItemProvider> extras) {
        this.itemSorter.addToSortingList(extras);
    }

    public void initSortingList(List<IItemProvider> defaultList) {
        this.itemSorter.initSortingList(defaultList);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private ArrayList<Item> sortList = null;

        private ArrayList<Item> convertList(List<IItemProvider> sourceList) {
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < sourceList.size(); ++i) {
                list.add(sourceList.get(i).func_199767_j());
            }
            return list;
        }

        public void initSortingList(List<IItemProvider> sortList) {
            if (this.sortList == null) {
                this.sortList = this.convertList(sortList);
            } else {
                ArrayList<Item> copyList = this.sortList;
                this.sortList = this.convertList(sortList);
                for (int i = 0; i < copyList.size(); ++i) {
                    this.sortList.add((Item)copyList.get(i));
                }
            }
        }

        public void addToSortingList(List<IItemProvider> extras) {
            if (this.sortList == null) {
                this.sortList = this.convertList(extras);
                return;
            }
            for (int i = 0; i < extras.size(); ++i) {
                this.sortList.add(extras.get(i).func_199767_j());
            }
            LightmansCurrency.LogInfo("Added " + extras.size() + " items to the creative tab sorting list.");
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            Item item1 = o1.func_77973_b();
            Item item2 = o2.func_77973_b();
            if (this.sortList == null) {
                LightmansCurrency.LogWarning("No sortlist defined for this CurrencyGroup.");
                return 0;
            }
            if (this.sortList.contains(item1) && !this.sortList.contains(item2)) {
                return -1;
            }
            if (!this.sortList.contains(item1) && this.sortList.contains(item2)) {
                return 1;
            }
            if (this.sortListContains(item1) && this.sortListContains(item2)) {
                int index2;
                int index1 = this.indexOf(item1);
                if (index1 < (index2 = this.indexOf(item2))) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        private boolean sortListContains(Item item) {
            return this.indexOf(item) >= 0;
        }

        private int indexOf(Item item) {
            for (int i = 0; i < this.sortList.size(); ++i) {
                if (item != this.sortList.get(i)) continue;
                return i;
            }
            return -1;
        }
    }
}

